<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controlname;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;


        $this->controlname = 'contact';
        $this->smarty->assign('contact', 1);

        require_once("header.php");
        require_once("footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        $this->smarty->assign('msg', $_SESSION['msg']);
        unset($_SESSION['msg']);

        $siteinfo = R::findOne('siteinfo', 'order by id desc');
        $this->smarty->assign('siteinfo', $siteinfo);

        header::headershow($this->smarty, $this->hosturl);

        $this->smarty->display('templates/' . default_lang_interface . '/contact.html');
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function sendmsg() {
        $name = filter_input(INPUT_POST, 'name');
        $email = filter_input(INPUT_POST, 'email');
        $subject = filter_input(INPUT_POST, 'subject');
        $phone = filter_input(INPUT_POST, 'phone');
        $message = filter_input(INPUT_POST, 'message');

        if ($name && $email && $phone && $message) {
            $contactMsg = R::dispense('contactmsg');

            $contactMsg->name = $name;
            $contactMsg->email = $email;
            $contactMsg->title = ""; //$subject;
            $contactMsg->phone = $phone;
            $contactMsg->msg = $message;
            $contactMsg->mdate = date('Y-m-d H:i:s');
            $contactMsg->read = 0;
            $contactMsg->del = 0;

            $info = R::findOne('siteinfo', 'order by id desc');

            $to = $info->email;
            $subject = 'رسالة جديدة على موقع ' . $info->project_name;
            $messag = "رسالة من " . $name . " <br/> " . $message;

            $headers = 'MIME-Version: 1.0' . "\r\n";
            $headers .= 'Content-type: text/html; charset=UTF-8' . "\r\n";
            $headers .= "From: " . $email;

            try {
                R::store($contactMsg);
                mail($to, $subject, $messag, $headers);
                $_SESSION['msg'] = 1;
            } catch (Exception $e) {
                $_SESSION['msg'] = -1;
            }
        } else {
            $_SESSION['msg'] = -1;
        }

        if (filter_input(INPUT_POST, 'src') == "index") {
            header('location:' . $this->hosturl . '#consultation');
        } else {
            header('location:' . $this->hosturl . '/' . $this->controlname);
        }
    }

// at the end of class call
    public function __destruct() {
//close connection
        R::close();
    }

}
