<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controlname;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;


        $this->controlname = 'branch';
        $this->smarty->assign('branch', 1);

        require_once("header.php");
        require_once("footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        $allBranch = R::findAll('branch', 'hide = 0');
        $this->smarty->assign('allBranch', $allBranch);

        header::headershow($this->smarty, $this->hosturl);
        $this->smarty->display('templates/' . default_lang_interface . '/branch.html');
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function getCity() {
        $id = filter_input(INPUT_POST, 'id');

        $allCity = R::findAll('city', 'regionid = ' . $id);

        if ($_SESSION['new_lang'] == "ar") {
            $data = '<option value="">اختر المدينة</option>';
            foreach ($allCity as $city) {
                $data .= '<option value="' . $city->id . '">' . $city->title . '</option>';
            }
        } else {
            $data = '<option value="">Select City</option>';
            foreach ($allCity as $city) {
                $data .= '<option value="' . $city->id . '">' . $city->title_en . '</option>';
            }
        }
        print_r($data);
    }

    public function getBranch() {
        $regionid = filter_input(INPUT_POST, 'regionid');
        $cityid = filter_input(INPUT_POST, 'cityid');

        if ($cityid) {
            $allBranch = R::findAll('branch', 'hide = 0 and cityid = ' . $cityid);
        } else {
            $allBranch = R::findAll('branch', 'hide = 0 and regionid = ' . $regionid);
        }
        if ($allBranch) {

            $data = '';

            if ($_SESSION['new_lang'] == "ar") {
                foreach ($allBranch as $branch) {
                    $data .= '<div class="branch-single">
                        <div class="col-sm-12">';
                    $data .= '<i class="fa fa-map-marker" aria-hidden="true"></i><h6>' . $branch->title . '</h6>
                          <p >العنوان:<span>' . $branch->address . '</span></p>
                          <p>الاتصال: <a href="tel:">' . $branch->phone . '</a></p>';

                    $data.='</div>
                </div>';
                }
            } else {
                foreach ($allBranch as $branch) {
                    $data .= '<div class="branch-single">
                        <div class="col-sm-12">';
                    $data .= '<i class="fa fa-map-marker" aria-hidden="true"></i><h6>' . $branch->title_en . '</h6>
                          <p >Address:<span>' . $branch->address_en . '</span></p>
                          <p>contact: <a href="tel:">' . $branch->phone . '</a></p>';

                    $data.='</div>
                </div>';
                }
            }
        } else {
            if ($_SESSION['new_lang'] == "ar") {
                $data = 'لا يوجد فروع';
            } else {
                $data = 'No Branches Found';
            }
        }
        print_r($data);
    }

    public function citymap() {
        $value = filter_input(INPUT_POST, 'ths_val');
        $regionid = filter_input(INPUT_POST, 'regionid');
        $lat_lan1 = array();
        if ($value)
            $result2 = R::getAll('SELECT * FROM branch where cityid=' . $value . '');
        elseif ($regionid)
            $result2 = R::getAll('SELECT * FROM branch where regionid=' . $regionid . '');
        else
            $result2 = R::getAll('SELECT * FROM branch');

        foreach ($result2 as $single2) {
            $arr = array('lat' => $single2['lat'], 'long' => $single2['long']);
            array_push($lat_lan1, $arr);
            //echo $single2['long'];
        }
        echo json_encode($lat_lan1);
        // echo $single['city_id'];
        //}
    }

    public function mymap() {
        $value = filter_input(INPUT_POST, 'ths_val');
        $regionid = filter_input(INPUT_POST, 'regionid');
        //echo ' value = '.$value;
        if ($value)
            $result = R::getAll('SELECT * FROM branch where cityid=' . $value . '');
        elseif ($regionid)
            $result = R::getAll('SELECT * FROM branch where regionid=' . $regionid . '');
        else
            $result = R::getAll('SELECT * FROM branch');
        $lat_lan = array();
        foreach ($result as $row) {
            $new_arr = array('id' => $row['id'], 'lat' => $row['lat'], 'lan' => $row['long'], 'title' => $row['title']);
            array_push($lat_lan, $new_arr);
            // echo "addMarker(new google.maps.LatLng(" . $row['lat'] . ", " . $row['long'] . "), map ," . $row['id'] . ");";
        }
        echo json_encode($lat_lan);
    }

// at the end of class call
    public function __destruct() {
//close connection
        R::close();
    }

}
