<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'voting';
        $this->shcontrollname = 'التصويت';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'voting'; //controller name or tab name
        $active[1] = 'voting'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'votingadd';
                break;
            case 'show':$active[2] = 'votingshow';
                break;
            default :$active[2] = 'votingshow';
                break;
        }
        $this->active = $active;


        #include upload function
        //require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('voting/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {


        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //vars here
        $question = filter_input(INPUT_POST, 'question');
        $question_en = filter_input(INPUT_POST, 'question_en');
        $itr = (int) filter_input(INPUT_POST, 'itr');

        //here the add
        $voting = R::dispense('voting');
        $voting->question = $question;
        $voting->question_en = $question_en;
        $voting->hide = 0;
        $voting->del = 0;

        R::begin();
        try {
            $id = R::store($voting);
            for ($i = 1; $i < $itr; $i++) {
                $ans = filter_input(INPUT_POST, 'ans' . $i);
                $ans_en = filter_input(INPUT_POST, 'ans_en' . $i);

                if (!$ans) {
                    continue;
                }

                //here the add
                $votinganswers = R::dispense('votinganswers');
                $votinganswers->voting_id = $id;
                $votinganswers->answer = $ans;
                $votinganswers->answer_en = $ans_en;
                R::store($votinganswers);
            }
            R::commit();
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            R::rollback();
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //here will load the menu show
        $pages = R::findAll('voting', ' del = 0 order by id desc');
        $this->smarty->assign('pages', $pages);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('voting/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all here
        $voting = R::load('voting', $itemid);
        $votinganswers = R::findAll('votinganswers', ' voting_id = ? ', [ $itemid]);
        $this->smarty->assign('voting', $voting);
        $this->smarty->assign('votinganswers', $votinganswers);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('voting/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');

        //vars here
        $question = filter_input(INPUT_POST, 'question');
        $question_en = filter_input(INPUT_POST, 'question_en');
        $itr = (int) filter_input(INPUT_POST, 'itr');

        //here the add
        $voting = R::load('voting', $id);
        $voting->question = $question;
        $voting->question_en = $question_en;

        R::begin();
        try {
            $id = R::store($voting);
            for ($i = 1; $i < $itr; $i++) {
                $ans = filter_input(INPUT_POST, 'ans' . $i);
                $ans_en = filter_input(INPUT_POST, 'ans_en' . $i);
                $ansid = filter_input(INPUT_POST, 'ansid' . $i);

                if (!$ans) {
                    continue;
                }

                if (!$ansid) {
                    //here the add
                    $votinganswers = R::dispense('votinganswers');
                    $votinganswers->voting_id = $id;
                    $votinganswers->answer = $ans;
                    $votinganswers->answer_en = $ans_en;
                    R::store($votinganswers);
                } else {
                    //here update
                    $votinganswers = R::load('votinganswers', $ansid);
                    $votinganswers->voting_id = $id;
                    $votinganswers->answer = $ans;
                    $votinganswers->answer_en = $ans_en;
                    R::store($votinganswers);
                }
            }
            R::commit();
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            R::rollback();
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all item here
        $voting = R::load('voting', $itemid);
        $voting->del = 1;
//        $votinganswers = R::findAll('votinganswers', ' voting_id = ? ', [ $itemid]);
        try {
//            R::trashAll($votinganswers);
//            R::trash($voting);
            R::store($voting);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function hideajax() {//old with ajax
        //get id for item
        $itemid = filter_input(INPUT_POST, 'itemid');
        $ishide = filter_input(INPUT_POST, 'ishide');

        //load all item here
        $page = R::load('voting', $itemid);

        $page->hide = $ishide;


        try {
            R::store($page);

            //change the button
            echo '1';
        } catch (Exception $e) {
            echo '0';
        }
    }

    public function hide() {//old with ajax
        //get id for item
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all item here
        $page = R::load('voting', $itemid);
        R::begin();
        try {
            if ($page->hide == 0) {
                $page->hide = 1;
                //it is hidden and i will show it
                //so hide all other
                $allVoting = R::findAll('voting');
                foreach ($allVoting as $value) {
                    $value->hide = 0;
                    R::store($value);
                }
            } else {
                $page->hide = 0;
            }
            R::store($page);



            R::commit();
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            R::rollback();
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function delanswer() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_POST, 'ansid');

//        $votinganswers = R::count('votinganswers', ' voting_id = ? ', [ $itemid]);
//        if ($votinganswers > 0) {
//            //header('Location:'.$this->hosturl.'/error/relate/'.$this->controllname);
//            exit();
//        }

        $voting_ans = R::load('votinganswers', $itemid);
        $done = 0;
        try {
            R::trash($voting_ans);
            $done = 1;
            echo $done;
        } catch (Exception $e) {
            $done = 0;
            echo $done;
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
