<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'videocategories';
        $this->shcontrollname = 'الفيديوهات';
        $this->tableName = 'videocategories';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'videocategories'; //controller name or tab name
        $active[1] = 'videocategories'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $videocategories = R::findAll('category', ' ORDER BY id DESC');
        $this->smarty->assign('videocategories', $videocategories);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('videocategories/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $id = filter_input(INPUT_GET, 'id');

        $category = R::findAll('category');
        $this->smarty->assign('category', $category);
        $this->smarty->assign('cat_id', $id);


        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('videocategories/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $id = filter_input(INPUT_GET, 'id');

        $videocategories = R::findAll('videocategories', 'category_id=' . $id . '');

        $this->smarty->assign('videocategories', $videocategories);
        $count_videocategories = count($videocategories);
        $this->smarty->assign('count_videos', $count_videocategories);

        $this->smarty->assign('cat_id', $id);


        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('videocategories/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function insertNewRow() {
        $Videoitr = filter_input(INPUT_POST, 'Videoitr');
        $this->smarty->assign('Videoitr', $Videoitr);
        $this->smarty->display('videocategories/addVideo.html');
    }

    public function insertNewVideo() {
        //update data row
        try {
            $cat_id = filter_input(INPUT_POST, 'cat_id');
            $Videoitr = filter_input(INPUT_POST, 'Videoitr');

            for ($i = 1; $i <= $Videoitr; $i++) {

                $link = filter_input(INPUT_POST, 'link_' . $i);
                $title = filter_input(INPUT_POST, 'title_' . $i);
                $title_en = filter_input(INPUT_POST, 'title_en_' . $i);

                if (!$link) {
                    continue;
                }
                //here the add
                $video = R::dispense('videocategories');
                $video->category_id = $cat_id;
                $video->link = $link;

                $video->title = $title;
                $video->title_en = $title_en;
                $id = R::store($video);
            }
            header('Location:' . $this->hosturl . '/' . $this->controllname);
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function updateit() {
        //update data row
        try {
            $cat_id = filter_input(INPUT_POST, 'cat_id');
            $Videoitr = filter_input(INPUT_POST, 'Videoitr');

            R::exec('DELETE from videocategories WHERE category_id = ' . $cat_id);

            for ($i = 1; $i <= $Videoitr; $i++) {

                $link = filter_input(INPUT_POST, 'link_' . $i);
                $title = filter_input(INPUT_POST, 'title_' . $i);
                $title_en = filter_input(INPUT_POST, 'title_en_' . $i);

                if (!$link) {
                    continue;
                }
                //here the add
                $video = R::dispense('videocategories');
                $video->category_id = $cat_id;
                $video->link = $link;

                $video->title = $title;
                $video->title_en = $title_en;
                $id = R::store($video);
            }
            header('Location:' . $this->hosturl . '/' . $this->controllname);
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function delVideo() {
        $id = filter_input(INPUT_POST, "rowId");

        $myData = R::load("videocategories", $id);
        R::trash($myData);

        echo 1;
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
