<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'trainer';
        $this->shcontrollname = 'الشركات الصديقة';
        $this->tableName = 'trainer';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'trainer'; //controller name or tab name
        $active[1] = 'trainer'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('trainer/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'name');
        $content = filter_input(INPUT_POST, 'details');
        $title_en = filter_input(INPUT_POST, 'name_en');
        $content_en = filter_input(INPUT_POST, 'details_en');
        $image = uploadnew('trainer', False, 0, 0, 'trainer');

        //here the add
        $trainer = R::dispense('trainer');
        $trainer->name = $title;
        $trainer->details = $content;
        $trainer->name_en = $title_en;
        $trainer->details_en = $content_en;
        $trainer->image = $image;
        $trainer->del = 0;
        try {
            $id = R::store($trainer);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $trainers = R::findAll('trainer', 'del = 0');
        $this->smarty->assign('returnedData', $trainers);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('trainer/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $trainers = R::findAll('trainer', 'order by id desc');
        $this->smarty->assign('trainers', $trainers);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $trainer = R::load('trainer', $itemid);
        $this->smarty->assign('returnedData', $trainer);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('trainer/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $title = filter_input(INPUT_POST, 'name');
        $content = filter_input(INPUT_POST, 'details');
        $title_en = filter_input(INPUT_POST, 'name_en');
        $content_en = filter_input(INPUT_POST, 'details_en');
        $image = uploadupdate('trainer', 'imageurl', False, 0, 0, 'trainer');


        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $trainer = R::load('trainer', $id);

        //here the upadte
        $trainer->name = $title;
        $trainer->details = $content;
        $trainer->name_en = $title_en;
        $trainer->details_en = $content_en;
        $trainer->image = $image;

        try {
            R::store($trainer);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $trainer = R::load('trainer', $itemid);
//        if (file_exists('../../upload/' . $this->controllname . '/' . $trainer->image)) {
//            //echo $imageNewName;
//            chmod('../../upload/' . $this->controllname . '/' . $trainer->image, 0777);
//            unlink('../../upload/' . $this->controllname . '/' . $trainer->image);
//        }
        $trainer->del = 1;
        try {

            R::store($trainer);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
            $trainer = R::load('trainer', $id);
            if (file_exists('../../upload/' . $this->controllname . '/' . $trainer->image)) {
                //echo $imageNewName;
                chmod('../../upload/' . $this->controllname . '/' . $trainer->image, 0777);
                unlink('../../upload/' . $this->controllname . '/' . $trainer->image);
            }
            R::trash($trainer);
        }
        echo 1;
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
