<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'teams';
        $this->shcontrollname = 'الفرق';
        $this->tableName = 'teams';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'club'; //controller name or tab name
        $active[1] = 'teams'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        
        $allActivity = R::findAll('teams','type = 0 and del = 0');
        $this->smarty->assign('allActivity',$allActivity);
        
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('teams/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $type = filter_input(INPUT_POST, 'type');
        $activity = 0;
        if($type == 1)
            $activity = filter_input (INPUT_POST, 'activity');
        //here the add
        $teams = R::dispense('teams');
        $teams->name = $name;
        $teams->name_en = $name_en;
        $teams->type = $type;
        $teams->activity = $activity;
        $teams->del = 0;
        try {
            $id = R::store($teams);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $this->smarty->assign('msg',$_SESSION['tmsg']);
        unset($_SESSION['tmsg']);
        
        //here will load the menu show
        $teams = R::findAll('teams', 'del = 0 order by id desc');
        $this->smarty->assign('returnedData', $teams);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('teams/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
//        $teams = R::findAll('teams', 'order by id desc');
//        $this->smarty->assign('teams', $teams);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $one_team = R::load('teams', $itemid);
        $this->smarty->assign('team', $one_team);

        $allActivity = R::findAll('teams','type = 0 and del = 0 and id != '.$itemid);
        $this->smarty->assign('allActivity',$allActivity);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('teams/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $type = filter_input(INPUT_POST, 'type');
        $activity = 0;
        if($type == 1)
            $activity = filter_input (INPUT_POST, 'activity');

        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $teams = R::load('teams', $id);

        $teams->name = $name;
        $teams->name_en = $name_en;
        $teams->type = $type;
        $teams->activity = $activity;

        try {
            R::store($teams);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $teams = R::load('teams', $itemid);
        $app;
        if($teams->type == 0)    
        {
            $allTeams = R::findAll ('teams','del = 0 and activity = '.$itemid);
            $msg = "لا يمكن حذف هذا النشاط لأن به فرق";
        }
        else
        {
            $members = R::findAll ('members','team_id = '.$itemid);
            $msg = "لا يمكن حذف هذا الفريق لأن به أعضاء";
        }
        if(count($allTeams) > 0 || count($members) > 0)
        {
            $app = -1;
        }
//        if (file_exists('../../upload/' . $this->controllname . '/' . $teams->image)) {
//            //echo $imageNewName;
//            chmod('../../upload/' . $this->controllname . '/' . $teams->image, 0777);
//            unlink('../../upload/' . $this->controllname . '/' . $teams->image);
//        }

        try {
            if($app == -1)
                $_SESSION['tmsg'] = $msg;
            else
            {
                $teams->del = 1;
                R::store($teams);
            }
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }
    
    public function deleteselected() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        $app = 0;
        foreach ($deleteidsArray as $id) {
            //load all item here
            $teams = R::load('teams', $id);
            if($teams->type == 0)    
                $allTeams = R::findAll ('teams','del = 0 and activity = '.$id);
            else
                $members = R::findAll ('members','team_id = '.$id);
            if(count($allTeams) > 0 || count($members) > 0)
            {
                $app = -1;
            }
            else
            {
                $teams->del = 1;
                R::store($teams);
            }
        }
        if($app == -1)
            echo $app;
        else
            echo 1;
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
