<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'services';
        $this->shcontrollname = 'خدماتنا';
        $this->tableName = 'services';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'services'; //controller name or tab name
        $active[1] = 'services'; //controller name
        $this->active = $active;

        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");

        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('services/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $content = filter_input(INPUT_POST, 'content');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content_en = filter_input(INPUT_POST, 'content_en');
        $image = uploadnew('slider', False, 0, 0, 'services');
        $price = (float) filter_input(INPUT_POST, 'price');

        //here the add
        $services = R::dispense('services');
        $services->title = $title;
        $services->content = $content;
        $services->title_en = $title_en;
        $services->content_en = $content_en;
        $services->image = $image;
        $services->price = $price;
        $services->del = 0;
        $services->hide = 0;
        try {
            $id = R::store($services);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            echo $e;
//            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $services = R::getAll('SELECT * FROM `services` WHERE `del` = 0');
        $this->smarty->assign('returnedData', $services);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('services/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $service = R::load('services', $itemid);
        $this->smarty->assign('returnedData', $service);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('services/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $content = filter_input(INPUT_POST, 'content');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content_en = filter_input(INPUT_POST, 'content_en');
        $image = uploadupdate('slider', 'imageurl', False, 0, 0, 'services');
        $price = (float) filter_input(INPUT_POST, 'price');

        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $services = R::load('services', $id);

        //here the upadte
        $services->title = $title;
        $services->content = $content;
        $services->title_en = $title_en;
        $services->content_en = $content_en;
        $services->image = $image;
        $services->price = $price;
        $services->del = 0;
        try {
            R::store($services);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $services = R::load('services', $itemid);
//        if (file_exists('../../upload/' . $this->controllname . '/' . $slider->image)) {
//            //echo $imageNewName;
//            chmod('../../upload/' . $this->controllname . '/' . $slider->image, 0777);
//            unlink('../../upload/' . $this->controllname . '/' . $slider->image);
//        }

        $services->del = 1;


        try {
            R::store($services);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function hide() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_POST, 'itemid');
        $ishide = filter_input(INPUT_POST, 'ishide');
        //load all item here
        $slider = R::load('services', $itemid);
        $slider->hide = $ishide;
        try {
            R::store($slider);
            //change the button
            echo '1';
        } catch (Exception $e) {
            echo '0';
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
