<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'projects';
        $this->shcontrollname = 'مشاريعنا';
        $this->tableName = 'projects';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'slider'; //controller name or tab name
        $active[1] = 'slider'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('projects/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $content = filter_input(INPUT_POST, 'content');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content_en = filter_input(INPUT_POST, 'content_en');
        $image = uploadnew('project', False, 0, 0, 'projects');
        $itr = filter_input(INPUT_POST, 'itr');





        //here the add
        $projects = R::dispense('projects');
        $projects->title = $title;
        $projects->content = $content;
        $projects->title_en = $title_en;
        $projects->content_en = $content_en;
        $projects->image = $image;
        $projects->del = 0;
        $id = R::store($projects);
        for ($i = 1; $i <= $itr; $i++) {
            $projectsgallery = R::dispense('projectsgallery');

            $img = uploadnew('cls_img_' . $i . '', False, 0, 0, 'projectsgallery');

            if (isset($img) && $img != 'no image') {
                $projectsgallery->project_id = $id;
                $projectsgallery->image = $img;
                $scl_sch_img_id = R::store($projectsgallery);
            }
        }

        try {

            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $projects = R::getAll("select* from projects where del = 0");
        $this->smarty->assign('returnedData', $projects);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('projects/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $$projects = R::findAll('projects', 'order by id desc');
        $this->smarty->assign('projects', $projects);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $project = R::load('projects', $itemid);
        $this->smarty->assign('returnedData', $project);
        $images = R::getAll("select* from projectsgallery where project_id = $itemid");
        $count_imgs = count($images);

        $this->smarty->assign('count_imgs', $count_imgs);

        $this->smarty->assign('images', $images);





        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('projects/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $content = filter_input(INPUT_POST, 'content');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content_en = filter_input(INPUT_POST, 'content_en');
        $image = uploadupdate('project', 'imageurl', False, 0, 0, 'projects');
        $itr = filter_input(INPUT_POST, 'itr');

        $id = filter_input(INPUT_POST, 'id');




        //here the add
        $projects = R::load('projects', $id);
        $projects->title = $title;
        $projects->content = $content;
        $projects->title_en = $title_en;
        $projects->content_en = $content_en;
        $projects->image = $image;
        $projects->del = 0;
        $id = R::store($projects);
        R::exec('DELETE from projectsgallery WHERE project_id = ' . $id);

        for ($i = 1; $i <= $itr; $i++) {
            $projectsgallery = R::dispense('projectsgallery');
            $img = uploadnew('cls_img_' . $i . '', False, 0, 0, 'projectsgallery');
            //# get old imgs.
            if ($img == 'no image') {
                $img = filter_input(INPUT_POST, 'imageurl_' . $i . '');
            }
            if (isset($img) && $img != 'no image') {

                $projectsgallery->project_id = $id;
                $projectsgallery->image = $img;
                R::store($projectsgallery);
            }
        }

        try {

            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $project = R::load('projects', $itemid);
        $project->del = 1;
        R::store($project);

        try {

            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
