<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'products_categories';
        $this->shcontrollname = ' تصنيف المنتجات';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'appsetting'; //controller name or tab name
        $active[1] = 'productsshow'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'products_categoriesadd';
                break;
            case 'show':$active[2] = 'products_categoriesshow';
                break;
            default :$active[2] = 'products_categoriesshow';
                break;
        }
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $productscategory = R::findAll('productscategory','del = 0');
        $this->smarty->assign('productscategory', $productscategory);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('products_categories/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);



        //vars here
        $name_ar = filter_input(INPUT_POST, 'name_ar');
        $name_en = filter_input(INPUT_POST, 'name_en');

        $parent = filter_input(INPUT_POST, 'parent');
        $image = uploadnew('file', False, 0, 0, 'products_categories');

        //here the add
        $productscategory = R::dispense('productscategory');
        $productscategory->productname_ar = $name_ar;
        $productscategory->productname_en = $name_en;
        $productscategory->parent = $parent;
        $productscategory->image = $image;
        $productscategory->del = 0;



        try {
            R::store($productscategory);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $this->smarty->assign('msg',$_SESSION['pmsg']);
        unset($_SESSION['pmsg']);

        //here will load the menu show
        $productscategory = R::findAll('productscategory',' del=0 order by id desc');
        $this->smarty->assign('productscategory', $productscategory);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('products_categories/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        $productscategory = R::findAll('productscategory','del = 0');
        $this->smarty->assign('productscategory', $productscategory);
        //load all here
        $productscategory_elements = R::load('productscategory', $itemid);
        $this->smarty->assign('productscategory_elements', $productscategory_elements);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('products_categories/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);



        $id = filter_input(INPUT_POST, 'id');


        //vars here
        $name_ar = filter_input(INPUT_POST, 'name_ar');
        $name_en = filter_input(INPUT_POST, 'name_en');

        $parent = filter_input(INPUT_POST, 'parent');
        $image = uploadupdate('image1', 'imageurl1', False, 0, 0, 'products_categories');
        //here the add
        $productscategory = R::load('productscategory', $id);
        $productscategory->productname_ar = $name_ar;
        $productscategory->productname_en = $name_en;
        $productscategory->parent = $parent;
        $productscategory->image = $image;
        $productscategory->del = 0;
        R::store($productscategory);

        header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all item here
        $products_category = R::load('productscategory', $itemid);
        $allProducts = R::findAll('products','category_id = '.$itemid.' and del = 0');
        try {
            if(count($allProducts) > 0)
            {
                $_SESSION['pmsg'] = "لا يمكنك حذف هذا التصنيف لأن به منتجات";
            }
            else {
                $products_category->del = 1;
                R::store($products_category);
            }
            //change the button
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }
    
    public function deleteselected() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        $app = 0;
        foreach ($deleteidsArray as $id) {
            
            $products_category = R::load('productscategory', $id);
            $allProducts = R::findAll('products','category_id = '.$id.' and del = 0');
        
            if(count($allProducts) > 0)
            {
                $app = -1;
            }
            else
            {
                $products_category->del = 1;
                R::store($products_category);
            }
        }
        if($app == -1)
            echo $app;
        else
            echo 1;
    }

    public function check() {

//check login
        autho::checkautho($this->hosturl);
//check authoize
//autho::checkauthoize($this->controllname,$this->hosturl,$_SESSION['role_id']);

        $name = filter_input(INPUT_POST, 'datainput2');
        $checkedit = filter_input(INPUT_POST, 'edit2');

        if (!empty($name)) {
            if (!$checkedit) {
//new
                $checkname = R::getRow('SELECT * FROM productscategory WHERE productname_ar= ? LIMIT 1', [$name]);

                if (count($checkname) > 0) {
                    echo "yes";
                } else {
                    echo "no";
                }
            } else {

//edit
                $checkname = R::getRow('SELECT * FROM productscategory WHERE productname_ar=? LIMIT 1', [$name]);

                if (count($checkname) > 0) {
                    if ($checkedit == $checkname['productname_ar']) {
                        echo "no";
                    } else {
                        echo "yes";
                    }
                } else {
                    echo "no";
                }
            }
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
