<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'products';
        $this->shcontrollname = 'المنتجات';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'appsetting'; //controller name or tab name
        $active[1] = 'productsshow'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'productsadd';
                break;
            case 'show':$active[2] = 'productsshow';
                break;
            default :$active[2] = 'productsshow';
                break;
        }
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $productscategory = R::findAll('productscategory', 'del = 0');
        $this->smarty->assign('productscategory', $productscategory);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('products/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);



        //vars here
        $name_ar = filter_input(INPUT_POST, 'name_ar');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $details = filter_input(INPUT_POST, 'details');
        $details_en = filter_input(INPUT_POST, 'details_en');
        $category = filter_input(INPUT_POST, 'category');
        $itr = filter_input(INPUT_POST, 'itr');

        //here the add
        $products = R::dispense('products');
        $products->productname_ar = $name_ar;
        $products->productname_en = $name_en;
        $products->details = $details;
        $products->details_en = $details_en;
        $products->category_id = $category;
        $products->del = 0;
        $id = R::store($products);

        for ($i = 1; $i <= $itr; $i++) {
            $productsgallery = R::dispense('productsgallery');

            $img = uploadnew('cls_img_' . $i . '', False, 0, 0, 'productsgallery');

            if (isset($img) && $img != 'no image') {
                $productsgallery->product_id = $id;
                $productsgallery->name = $img;
                R::store($productsgallery);
            }
        }


        try {

            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //here will load the menu show
        $products = R::GETAll('SELECT * FROM `products` WHERE `del` = 0 order by id desc');
        $this->smarty->assign('products', $products);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('products/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        $productscategory = R::findAll('productscategory', 'del = 0');
        $this->smarty->assign('productscategory', $productscategory);

        //load all here
        $products = R::load('products', $itemid);
        $this->smarty->assign('products', $products);

        $images = R::getAll("SELECT * FROM `productsgallery` WHERE `product_id`  = $itemid");
        $count_imgs = count($images);

        $this->smarty->assign('count_imgs', $count_imgs);

        $this->smarty->assign('images', $images);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('products/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $id = filter_input(INPUT_POST, 'id');
        $itr = filter_input(INPUT_POST, 'itr');
        //R::debug( TRUE );
        //load all parents here
        //vars here
        $name_ar = filter_input(INPUT_POST, 'name_ar');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $details = filter_input(INPUT_POST, 'details');
        $details_en = filter_input(INPUT_POST, 'details_en');
        $category = filter_input(INPUT_POST, 'category');
        //here the add
        $products = R::load('products', $id);
        $products->productname_ar = $name_ar;
        $products->productname_en = $name_en;
        $products->details = $details;
        $products->details_en = $details_en;
        $products->category_id = $category;
        $products->del = 0;
        $id = R::store($products);
        R::exec('DELETE from productsgallery WHERE product_id = ' . $id);

        for ($i = 1; $i <= $itr; $i++) {

            $productsgallery = R::dispense('productsgallery');

            $img = uploadnew('cls_img_' . $i . '', False, 0, 0, 'productsgallery');

            //# get old imgs.
            if ($img == 'no image') {
                $img = filter_input(INPUT_POST, 'imageurl_' . $i . '');
            }


            if (isset($img) && $img != 'no image') {

                $productsgallery->product_id = $id;
                $productsgallery->name = $img;

                R::store($productsgallery);
            }
        }

        header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        $products = R::load('products', $itemid);
        $products->del = 1;


        try {
            R::store($products);

            //change the button
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
            $products = R::load('products', $id);
            $products->del = 1;
            R::store($products);
        }
        echo 1;
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
