<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'point_table';
        $this->shcontrollname = 'جدول النقاط';
        $this->tableName = 'point_table';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'club'; //controller name or tab name
        $active[1] = 'point_table'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $point_table = R::findAll('pointtable','order by porder desc');
        $this->smarty->assign('point_table',$point_table);
        
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('point_table/point_table.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $new = filter_input(INPUT_POST, 'new');
        for($i=1; $i<=20; $i++)
        {
            $team = filter_input(INPUT_POST, 'team'.$i);
            $points = filter_input(INPUT_POST, 'points'.$i);
            $win = filter_input(INPUT_POST, 'win'.$i);
            $loss = filter_input(INPUT_POST, 'loss'.$i);
            $even = filter_input(INPUT_POST, 'even'.$i);
            $order = filter_input(INPUT_POST, 'order'.$i);
                
            
            if($new == 1)
            {
                $point_table = R::dispense('pointtable');
              
                $point_table->team = $team;
                $point_table->points = $points;
                $point_table->win = $win;
                $point_table->loss = $loss;
                $point_table->even = $even;
                $point_table->porder = $order;    
            } 
            else
            {
                $id = filter_input(INPUT_POST, 'id'.$i);
                $point_table = R::load('pointtable',$id);
              
                $point_table->team = $team;
                $point_table->points = $points;
                $point_table->win = $win;
                $point_table->loss = $loss;
                $point_table->even = $even;
                $point_table->porder = $order;
                $point_table->id = $id;
            }
            try {
                R::store($point_table);
                header('Location:' . $this->hosturl . '/' . $this->controllname);
            } catch (Exception $e) {
                //print_r($e);
                header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
            }
        }
        
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
