<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known

        $this->shcontrollname = ' معرض الصور';
        $this->controllname = 'photo';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");

        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);



        require_once("../../library/plugins/classupload/uploadfunctions.php");


        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'maincontent'; //controller name or tab name
        $active[1] = 'photoshow'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'photoadd';
                break;
            case 'show':$active[2] = 'photoshow';
                break;
            default :$active[2] = 'photoshow';
                break;
        }
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $allAlbum = R::findAll('photo');
        $this->smarty->assign('allAlbum', $allAlbum);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('photo/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $image = uploadnew('filee', False, 0, 0, 'photo');
        $albumId = filter_input(INPUT_POST, 'albumId');

        $imgitr = filter_input(INPUT_POST, 'imgitr');


        //here the add
        $product = R::dispense('photo');
        $product->name = $albumId;
        $product->name_en = $name_en;
        $product->image = $image;
        $product->is_active = 1;

        try {
            $id = R::store($product);
            //  $imgitr= $imgitr -1 ;
            for ($i = 1; $i <= $imgitr; $i++) {
                $image_name = filter_input(INPUT_POST, 'image_name' . $i);
                $image_name_en = filter_input(INPUT_POST, 'image_name_en' . $i);
                $image_file = uploadnew('image_file' . $i, False, 0, 0, 'photoimage');


                //print_r((filter_input(INPUT_POST, 'image_file' . $i))) ;

                if ($image_file == "no image") {
                    continue;
                }

                /* if (!$image_name) {
                  continue;
                  }
                 */
                if ($image_name == "") {
                    $image_name = $name;
                }
                if ($image_name_en == "") {
                    $image_name_en = $name_en;
                }


                //here the add
                $productimage = R::dispense('photoimage');
                $productimage->title = $image_name;
                $productimage->title_en = $image_name_en;
                $productimage->image = $image_file;
                $productimage->photo_id = $albumId;
                R::store($productimage);
            }
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //here will load the menu show
        $products = R::findAll('photo', 'order by id desc');
        $this->smarty->assign('products', $products);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('photo/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');


        //load all here
        $product = R::load('photo', $itemid);
        $this->smarty->assign('product', $product);


        $productimages = R::findAll('photoimage', 'photo_id = ?', [$product->id]);
        $this->smarty->assign('productimages', $productimages);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('photo/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $id = filter_input(INPUT_POST, 'id');
        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $image = uploadupdate('filee', 'imageurl', False, 0, 0, 'photo');
        $albumId = filter_input(INPUT_POST, 'albumId');


        $imgitr = filter_input(INPUT_POST, 'imgitr');


        //R::debug( TRUE );
        //load all parents here
        $product = R::load('photo', $id);

        //here the update
        $product->name = $albumId;
        $product->name_en = $name_en;
        $product->image = $image;


        try {
            R::store($product);
            for ($i = 1; $i <= $imgitr; $i++) {
                $image_name = filter_input(INPUT_POST, 'image_name' . $i);
                $image_name_en = filter_input(INPUT_POST, 'image_name_en' . $i);
                $propid = filter_input(INPUT_POST, 'propid' . $i);

                if ($image_name_en == "") {
                    $image_name_en = $name_en;
                }
                if ($image_name == "") {
                    $image_name = $name;
                }

                if (!$propid) {

                    $image_file = uploadnew('image_file' . $i, False, 0, 0, 'photoimage');


                    if ($image_file == "no image") {
                        continue;
                    }
                    //here the add
                    $productimage = R::dispense('photoimage');
                    $productimage->title = $image_name;
                    $productimage->title_en = $image_name_en;
                    $productimage->image = $image_file;
                    $productimage->photo_id = $id;
                    R::store($productimage);
                } else {

                    $image_file = uploadupdate('image_file' . $i, 'image_imageurl' . $i, False, 0, 0, 'photoimage');

                    //here update
                    $productimage = R::load('photoimage', $propid);
                    $productimage->title = $image_name;
                    $productimage->title_en = $image_name_en;
                    $productimage->image = $image_file;
                    $productimage->photo_id = $id;
                    R::store($productimage);
                }
            }

            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all item here
        $product = R::load('photo', $itemid);

        if (file_exists('../../upload/photo/' . $product->image)) {
            //echo $imageNewName;
            chmod('../../upload/photo/' . $product->image, 0777);
            unlink('../../upload/photo/' . $product->image);
        }

        try {

            //delete images
            $productimage = R::findAll('photoimage', 'photo_id = ?', [$itemid]);
            foreach ($productimage as $simage) {
                if (file_exists('../../upload/photoimage/' . $simage->image)) {
                    //echo $imageNewName;
                    chmod('../../upload/photoimage/' . $simage->image, 0777);
                    unlink('../../upload/photoimage/' . $simage->image);
                }
                R::trash($simage);
            }


            R::trash($product);

            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function delimage() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_POST, 'propid');

        //load all item here
        $productimage = R::load('photoimage', $itemid);

        if (file_exists('../../upload/photoimage/' . $productimage->image)) {
            //echo $imageNewName;
            chmod('../../upload/photoimage/' . $productimage->image, 0777);
            unlink('../../upload/photoimage/' . $productimage->image);
        }

        try {
            R::trash($productimage);
            $done = 1;
            echo $done;
        } catch (Exception $e) {
            $done = 0;
            echo $done;
        }
    }

    public function status() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $itemid = filter_input(INPUT_GET, 'id');

        //load all parents here
        $product = R::load('photo', $itemid);

        $is_active = $product->is_active;

        if ($is_active == 0) {
            $new_val = 1;
            $product->is_active = $new_val;
        } else {
            $new_val = 0;
            $product->is_active = $new_val;
        }


        try {
            R::store($product);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
