<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'next_match';
        $this->shcontrollname = 'المباراة القادمة';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'club';
        $active[1] = 'next_match'; //controller name or tab name
        $this->active = $active;

        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);

        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        #select table
        //$edited_data = R::getAll('SELECT * FROM matches order by id asc');
        $edited_data = R::load('matches', 1);
        if (count($edited_data) > 0) {

            //send info to html
            //$this->smarty->assign('edited_data', $edited_data[0]);
            $this->smarty->assign('edited_data', $edited_data);
//            print_r($edited_data[0]);
        }
//
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('next_match/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    //the add and update in next_match table
    public function edit() {

        //check login
        autho::checkautho($this->hosturl);

        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get all vars
        $name1 = filter_input(INPUT_POST, 'name1');
        $name1_en = filter_input(INPUT_POST, 'name1_en');
        $name2 = filter_input(INPUT_POST, 'name2');
        $name2_en = filter_input(INPUT_POST, 'name2_en');
//        $content = filter_input(INPUT_POST, 'content');
//        $content_en = filter_input(INPUT_POST, 'content_en');
        $place = filter_input(INPUT_POST, 'place');
        $place_en = filter_input(INPUT_POST, 'place_en');
        $datetime = filter_input(INPUT_POST, 'datetime');

        #select table
        $edited_data = R::load('matches', 1);
        if (count($edited_data) > 0) {
            //update current
            //get id vars in update statution
            $id = filter_input(INPUT_POST, 'id');
            $logo1 = uploadupdate('logo1', 'imageurl1', False, 0, 0, 'next_match');
            $logo2 = uploadupdate('logo2', 'imageurl2', False, 0, 0, 'next_match');

            // echo $id ;

            $edited_data = R::load('matches', 1);

            //fill object with data
            $edited_data->name1 = $name1;
            $edited_data->name1_en = $name1_en;
            $edited_data->name2 = $name2;
            $edited_data->name2_en = $name2_en;

//            $edited_data->content = $content;
//            $edited_data->content_en = $content_en;

            $edited_data->logo1 = $logo1;
            $edited_data->logo2 = $logo2;
            $edited_data->place = $place;
            $edited_data->place_en = $place_en;
            $edited_data->datetime = $datetime;

            R::store($edited_data);

            try {
                R::store($edited_data);
                header('Location:' . $this->hosturl . '/' . $this->controllname . '/index');
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
            }
        } else {
            //insert new
            $logo1 = uploadnew('logo1', False, 0, 0, 'next_match');
            $logo2 = uploadnew('logo2', False, 0, 0, 'next_match');

            $edited_data = R::dispense('matches');

            //fill object with data

            $edited_data->id = 1;
            $edited_data->name1 = $name1;
            $edited_data->name1_en = $name1_en;
            $edited_data->name2 = $name2;
            $edited_data->name2_en = $name2_en;

//            $edited_data->content = $content;
//            $edited_data->content_en = $content_en;

            $edited_data->logo1 = $logo1;
            $edited_data->logo2 = $logo2;
            $edited_data->place = $place;
            $edited_data->place_en = $place_en;
            $edited_data->datetime = $datetime;
            try {
                $id = R::store($edited_data);
                header('Location:' . $this->hosturl . '/' . $this->controllname . '/index');
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
            }
        }
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
