<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'news';
        $this->shcontrollname = 'الشهادات';
        $this->tableName = 'news';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'news'; //controller name or tab name
        $active[1] = 'news'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('news/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');

        $content = filter_input(INPUT_POST, 'content');
        $content_en = filter_input(INPUT_POST, 'content_en');

        $date = filter_input(INPUT_POST, 'date');

        $place = filter_input(INPUT_POST, 'place');
        $place_en = filter_input(INPUT_POST, 'place_en');

        $image = uploadnew('image', False, 0, 0, 'news');

        //here the add
        $news = R::dispense('news');
        $news->title = $title;
        $news->title_en = $title_en;

        $news->content = $content;
        $news->content_en = $content_en;

        $news->place = $place;
        $news->place_en = $place_en;

        $news->date = $date;
        $news->image = $image;

        try {
            $id = R::store($news);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $news = R::findAll('news', 'order by id desc');
        $this->smarty->assign('returnedData', $news);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('news/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $news = R::findAll('news', 'order by id desc');
        $this->smarty->assign('news', $news);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $one_news = R::load('news', $itemid);
        $this->smarty->assign('returnedData', $one_news);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('news/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');

        $content = filter_input(INPUT_POST, 'content');
        $content_en = filter_input(INPUT_POST, 'content_en');

        $place = filter_input(INPUT_POST, 'place');
        $place_en = filter_input(INPUT_POST, 'place_en');

        $date = filter_input(INPUT_POST, 'date');
        $image = uploadupdate('image', 'imageurl', False, 0, 0, 'news');


        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $news = R::load('news', $id);

        //here the upadte
        $news->title = $title;
        $news->title_en = $title_en;

        $news->content = $content;
        $news->content_en = $content_en;

        $news->place = $place;
        $news->place_en = $place_en;

        $news->date = $date;
        $news->image = $image;

        try {
            R::store($news);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function hide() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_POST, 'itemid');
        $ishide = filter_input(INPUT_POST, 'ishide');
        //load all item here
        $news = R::load('news', $itemid);
        $news->hide = $ishide;
        try {
            R::store($news);
            //change the button
            echo '1';
        } catch (Exception $e) {
            echo '0';
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $news = R::load('news', $itemid);
        if (file_exists('../../upload/' . $this->controllname . '/' . $news->image)) {
            //echo $imageNewName;
            chmod('../../upload/' . $this->controllname . '/' . $news->image, 0777);
            unlink('../../upload/' . $this->controllname . '/' . $news->image);
        }

        try {

            R::trash($news);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
            $news = R::load('news', $id);
            if (file_exists('../../upload/' . $this->controllname . '/' . $news->image)) {
                //echo $imageNewName;
                chmod('../../upload/' . $this->controllname . '/' . $news->image, 0777);
                unlink('../../upload/' . $this->controllname . '/' . $news->image);
            }
            R::trash($news);
        }
        echo 1;
    }

    public function showComments() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show

        $id = filter_input(INPUT_GET, 'id');
        $newsData = R::load('news', $id);
        $this->smarty->assign('newsData', $newsData);

        $allComments = R::findAll('comments', 'news_id = ' . $id . ' and del != 1');
        $this->smarty->assign('allComments', $allComments);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('news/comments.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function delComment() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_POST, 'itemid');
        //load all item here
        $comment = R::load('comments', $itemid);
        $comment->del = 1;
        try {
            R::store($comment);
            echo 1;
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function approveComment() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item

        $id = filter_input(INPUT_GET, 'id');
        if (empty($id)) {
            $itemid = filter_input(INPUT_POST, 'itemid');
            $approved = filter_input(INPUT_POST, 'ishide');
            //load all item here
            $comments = R::load('comments', $itemid);
            if ($approved == 0)
                $comments->approved = 1;
            else
                $comments->approved = 0;

            try {
                R::store($comments);
                echo 1;
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
            }
        } else {
            try {
                R::exec('update comments set approved = 1 where news_id = ' . $id);
                header('Location:' . $this->hosturl . '/' . $this->controllname . '/showComments/' . $id);
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
            }
        }
    }

    //approve checked Comments
    public function ApproveChecked() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $approveidsString = $_POST['approveids'];
        $approveidsArray = explode(',', $approveidsString);
        foreach ($approveidsArray as $id) {
            $comment = R::load('comments', $id);
            $comment->approved = 1;
            R::store($comment);
        }
        echo 1;
    }

    public function refuseChecked() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $approveidsString = $_POST['approveids'];
        $approveidsArray = explode(',', $approveidsString);
        foreach ($approveidsArray as $id) {
            $comment = R::load('comments', $id);
            $comment->approved = 0;
            R::store($comment);
        }
        echo 1;
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
