<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'my_team';
        $this->shcontrollname = 'بيانات فريقي';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'club';
        $active[1] = 'my_team'; //controller name or tab name
        $this->active = $active;

        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);

        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        #select table
        $edited_data = R::getAll('SELECT * FROM myteam order by id asc');
        if (count($edited_data) > 0) {

            //send info to html
            $this->smarty->assign('edited_data', $edited_data[0]);
//            print_r($edited_data[0]);
        }
//
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('my_team/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    //the add and update in my_team table
    public function edit() {

        //check login
        autho::checkautho($this->hosturl);

        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get all vars
        $name = filter_input(INPUT_POST, 'name1');
        $name_en = filter_input(INPUT_POST, 'name1_en');
        #select table
        $edited_data = R::findAll('myteam', 'order by id desc');
        if (count($edited_data) > 0) {
            //update current
            //get id vars in update statution
            $id = filter_input(INPUT_POST, 'id');
            $logo = uploadupdate('logo1', 'imageurl1', False, 0, 0, 'my_team');
            // echo $id ;

            $edited_data = R::load('myteam', $id);

            //fill object with data
            $edited_data->name = $name;
            $edited_data->name_en = $name_en;
            $edited_data->logo = $logo;

            try {
                R::store($edited_data);
                header('Location:' . $this->hosturl . '/' . $this->controllname . '/index');
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
            }
        } else {
            //insert new
            $logo = uploadnew('logo1', False, 0, 0, 'my_team');

            $edited_data = R::dispense('myteam');

            //fill object with data
            $edited_data->name = $name;
            $edited_data->name_en = $name_en;
            $edited_data->logo = $logo;
            try {
                $id = R::store($edited_data);
                header('Location:' . $this->hosturl . '/' . $this->controllname . '/index');
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
            }
        }
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
