<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'members';
        $this->shcontrollname = 'اعضاء الفريق';
        $this->tableName = 'members';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'club'; //controller name or tab name
        $active[1] = 'members'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $allActivity = R::findAll('teams','del = 0');
        foreach ($allActivity as $activity)
        {
            if($activity->activity)
                $activity->act = R::load('teams',$activity->activity)->name;
            $teams = R::findAll('teams','del = 0 and activity = '.$activity->id);
            $activity->teams = $teams;
        }
        $this->smarty->assign('allActivity',$allActivity);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('members/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here


        try {
            $team_id = filter_input(INPUT_POST, 'team_id');
            $memberitr = filter_input(INPUT_POST, 'memberitr');
            for ($i = 1; $i <= $memberitr; $i++) {

                $name = filter_input(INPUT_POST, 'name_' . $i);
                $name_en = filter_input(INPUT_POST, 'name_en_' . $i);
                $position = filter_input(INPUT_POST, 'position_' . $i);
                $position_en = filter_input(INPUT_POST, 'position_en_' . $i);
                $number = filter_input(INPUT_POST, 'number_' . $i);
                $age = filter_input(INPUT_POST, 'age_' . $i);
                $image = uploadnew('image_' . $i, False, 0, 0, 'members');
                if (!$name) {
                    continue;
                }
                //here the add
                $members = R::dispense('members');
                $members->team_id = $team_id;
                $members->name = $name;
                $members->name_en = $name_en;
                $members->position = $position;
                $members->position_en = $position_en;
                $members->number = $number;
                $members->age = $age;
                $members->image = $image;

                $id = R::store($members);
            }
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $members = R::findAll('members','order by members.id desc');
        foreach ($members as $member)
        {
            $team = R::load('teams', $member->team_id);
            if($team->activity)
                $team->act = R::load('teams',$team->activity)->name;
            $member->team = $team;
        }
        
        $this->smarty->assign('returnedData', $members);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('members/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $allActivity = R::findAll('teams','del = 0');
        foreach ($allActivity as $activity)
        {
            if($activity->activity)
                $activity->act = R::load('teams',$activity->activity)->name;
            $teams = R::findAll('teams','del = 0 and activity = '.$activity->id);
            $activity->teams = $teams;
        }
        $this->smarty->assign('allActivity',$allActivity);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $one_members = R::load('members', $itemid);
        $this->smarty->assign('returnedData', $one_members);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('members/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $team_id = filter_input(INPUT_POST, 'team_id');
        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $position = filter_input(INPUT_POST, 'position');
        $position_en = filter_input(INPUT_POST, 'position_en');
        $number = filter_input(INPUT_POST, 'number');
        $age = filter_input(INPUT_POST, 'age');


        $image = uploadupdate('image', 'imageurl', False, 0, 0, 'members');


        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $members = R::load('members', $id);

        //here the upadte
        $members->team_id = $team_id;
        $members->name = $name;
        $members->name_en = $name_en;
        $members->position = $position;
        $members->position_en = $position_en;
        $members->number = $number;
        $members->age = $age;
        $members->image = $image;

        try {
            R::store($members);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $members = R::load('members', $itemid);
        if (file_exists('../../upload/' . $this->controllname . '/' . $members->image)) {
            //echo $imageNewName;
            chmod('../../upload/' . $this->controllname . '/' . $members->image, 0777);
            unlink('../../upload/' . $this->controllname . '/' . $members->image);
        }

        try {

            R::trash($members);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }
    
    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
            $members = R::load('members', $id);
            if (file_exists('../../upload/' . $this->controllname . '/' . $members->image)) {
                //echo $imageNewName;
                chmod('../../upload/' . $this->controllname . '/' . $members->image, 0777);
                unlink('../../upload/' . $this->controllname . '/' . $members->image);
            }
            R::trash($members);
        }
        echo 1;
    }

    public function insertNewMember() {
        $memberitr = filter_input(INPUT_POST, 'memberitr');
        $this->smarty->assign('memberitr', $memberitr);
        $this->smarty->display('members/addmember.html');
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
