<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'match_table';
        $this->shcontrollname = 'جدول المباريات';
        $this->tableName = 'matchtable';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'club'; //controller name or tab name
        $active[1] = 'match_table'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('match_table/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $match_area = filter_input(INPUT_POST, 'match_area');
        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $place = filter_input(INPUT_POST, 'place');
        $place_en = filter_input(INPUT_POST, 'place_en');
        $datetime = filter_input(INPUT_POST, 'datetime');


        $logo = uploadnew('logo', False, 0, 0, 'match_table');

        //here the add
        $match_table = R::dispense('matchtable');
        $match_table->match_area = $match_area;
        $match_table->name = $name;

        $match_table->name_en = $name_en;
        $match_table->place = $place;

        $match_table->place_en = $place_en;
        $match_table->datetime = $datetime;
        $match_table->logo = $logo;
        try {
            $id = R::store($match_table);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $match_table = R::findAll('matchtable', 'order by id desc');
        $this->smarty->assign('returnedData', $match_table);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('match_table/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $match_table = R::findAll('matchtable', 'order by id desc');
        $this->smarty->assign('match_table', $match_table);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $one_match_table = R::load('matchtable', $itemid);
        $this->smarty->assign('edited_data', $one_match_table);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('match_table/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $match_area = filter_input(INPUT_POST, 'match_area');
        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $place = filter_input(INPUT_POST, 'place');
        $place_en = filter_input(INPUT_POST, 'place_en');
        $datetime = filter_input(INPUT_POST, 'datetime');

        $logo = uploadupdate('logo', 'imageurl', False, 0, 0, 'match_table');


        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $match_table = R::load('matchtable', $id);

        //here the upadte
        $match_table->match_area = $match_area;
        $match_table->name = $name;

        $match_table->name_en = $name_en;
        $match_table->place = $place;

        $match_table->place_en = $place_en;
        $match_table->datetime = $datetime;
        $match_table->logo = $logo;

        try {
            R::store($match_table);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

//
//    public function hide() {
//
//        //check login
//        autho::checkautho($this->hosturl);
//        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
//
//        //get id for item
//        $itemid = filter_input(INPUT_POST, 'itemid');
//        $ishide = filter_input(INPUT_POST, 'ishide');
//        //load all item here
//        $match_table = R::load('matchtable', $itemid);
//        $match_table->hide = $ishide;
//        try {
//            R::store($match_table);
//            //change the button
//            echo '1';
//        } catch (Exception $e) {
//            echo '0';
//        }
//    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $match_table = R::load('matchtable', $itemid);
        if (file_exists('../../upload/' . $this->controllname . '/' . $match_table->logo)) {
            //echo $imageNewName;
            chmod('../../upload/' . $this->controllname . '/' . $match_table->logo, 0777);
            unlink('../../upload/' . $this->controllname . '/' . $match_table->logo);
        }

        try {

            R::trash($match_table);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }
    
    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
           $match_table = R::load('matchtable', $id);
            if (file_exists('../../upload/' . $this->controllname . '/' . $match_table->logo)) {
                //echo $imageNewName;
                chmod('../../upload/' . $this->controllname . '/' . $match_table->logo, 0777);
                unlink('../../upload/' . $this->controllname . '/' . $match_table->logo);
            }
            R::trash($match_table);
        }
        echo 1;
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
