<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'managementCenter';
        $this->shcontrollname = 'مركز الإدارة';
        $this->tableName = 'managementcenter';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'managementCenter'; //controller name or tab name
        $active[1] = 'managementCenter'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('managementCenter/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $position = filter_input(INPUT_POST, 'position');
        $position_en = filter_input(INPUT_POST, 'position_en');
        $image = uploadnew('image', False, 0, 0, 'managementCenter');

        //here the add
        $managementCenter = R::dispense('managementcenter');
        $managementCenter->name = $name;
        $managementCenter->name_en = $name_en;
        $managementCenter->position = $position;
        $managementCenter->position_en = $position_en;

        $managementCenter->image = $image;


        try {
            $id = R::store($managementCenter);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $managementCenter = R::findAll('managementcenter', 'order by id desc');
        $this->smarty->assign('returnedData', $managementCenter);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('managementCenter/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $managementCenter = R::findAll('managementcenter', 'order by id desc');
        $this->smarty->assign('managementCenter', $managementCenter);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $one_managementCenter = R::load('managementcenter', $itemid);
        $this->smarty->assign('returnedData', $one_managementCenter);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('managementCenter/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $position = filter_input(INPUT_POST, 'position');
        $position_en = filter_input(INPUT_POST, 'position_en');


        $image = uploadupdate('image', 'imageurl', False, 0, 0, 'managementCenter');


        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $managementCenter = R::load('managementcenter', $id);

        //here the upadte
        $managementCenter->name = $name;
        $managementCenter->name_en = $name_en;
        $managementCenter->position = $position;
        $managementCenter->position_en = $position_en;

        $managementCenter->image = $image;

        try {
            R::store($managementCenter);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $managementCenter = R::load('managementcenter', $itemid);
        if (file_exists('../../upload/' . $this->controllname . '/' . $managementCenter->image)) {
            //echo $imageNewName;
            chmod('../../upload/' . $this->controllname . '/' . $managementCenter->image, 0777);
            unlink('../../upload/' . $this->controllname . '/' . $managementCenter->image);
        }

        try {

            R::trash($managementCenter);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
