<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'job_mail';
        $this->shcontrollname = 'إيميل الوظائف';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'jobs';
        $active[1] = 'job_mail'; //controller name or tab name
        $this->active = $active;

        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        #select table
        $job_mail = R::findOne('jobmail', 'order by id desc');
        if (count($job_mail) > 0) {

            //send info to html
            $this->smarty->assign('job_mail', $job_mail);
        }
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('job_mail/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    //the add and update in job_mail table
    public function edit() {

        //check login
        autho::checkautho($this->hosturl);

        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get all vars
        $email = filter_input(INPUT_POST, 'email');

        #select table
        $setting = R::findAll('jobmail', 'order by id desc');
        if (count($setting) > 0) {
            //update current
            //get id vars in update statution
            $id = filter_input(INPUT_POST, 'id');          

            $setting = R::load('jobmail', $id);

            $setting->email = $email;
            R::store($setting);

            try {
                R::store($setting);
                header('Location:' . $this->hosturl . '/' . $this->controllname . '/index');
            } catch (Exception $e) {
//                header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
            }
        } else {
            //insert new
            $setting = R::dispense('jobmail');
            //fill object with data
            $setting->email = $email;
            try {
                $id = R::store($setting);
                header('Location:' . $this->hosturl . '/' . $this->controllname . '/index');
            } catch (Exception $e) {
//                header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
            }
        }
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
