<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'job';
        $this->shcontrollname = 'الوظائف';
        $this->tableName = 'job';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'jobs'; //controller name or tab name
        $active[1] = 'job'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('job/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $content = filter_input(INPUT_POST, 'content');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content_en = filter_input(INPUT_POST, 'content_en');
        $image = uploadnew('job', False, 0, 0, 'job');
        $jdate = filter_input(INPUT_POST, 'jdate');

        //here the add
        $job = R::dispense('job');
        $job->title = $title;
        $job->content = $content;
        $job->title_en = $title_en;
        $job->content_en = $content_en;
        $job->image = $image;
        $job->jdate = $jdate;
        try {
            $id = R::store($job);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $this->smarty->assign('msg',$_SESSION['amsg']);
        unset($_SESSION['amsg']);
        //here will load the menu show
        $jobs = R::findAll('job');
        $this->smarty->assign('returnedData', $jobs);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('job/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $jobs = R::findAll('job', 'order by id desc');
        $this->smarty->assign('jobs', $jobs);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $job = R::load('job', $itemid);
        $this->smarty->assign('returnedData', $job);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('job/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $content = filter_input(INPUT_POST, 'content');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content_en = filter_input(INPUT_POST, 'content_en');
        $image = uploadupdate('job', 'imageurl', False, 0, 0, 'job');
        $jdate = filter_input(INPUT_POST, 'jdate');


        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $job = R::load('job', $id);

        //here the upadte
        $job->title = $title;
        $job->content = $content;
        $job->title_en = $title_en;
        $job->content_en = $content_en;
        $job->image = $image;
        $job->jdate = $jdate;

        try {
            R::store($job);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function approveItem() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_POST, 'itemid');
        $ishide = filter_input(INPUT_POST, 'ishide');
        //load all item here
        $job = R::load('job', $itemid);
        $job->hide = $ishide;
        try {
            R::store($job);
            //change the button
            echo '1';
        } catch (Exception $e) {
            echo '0';
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $applicants = R::findAll('applicant','jobid = '.$itemid);
        if(count($applicants) > 0)
        {
            $_SESSION['amsg'] = "لا يمكنك حذف هذه الوظيفة لأن بها متقدمين";
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        }
        else
        {
            $job = R::load('job', $itemid);
            if (file_exists('../../upload/' . $this->controllname . '/' . $job->image)) {
                //echo $imageNewName;
                chmod('../../upload/' . $this->controllname . '/' . $job->image, 0777);
                unlink('../../upload/' . $this->controllname . '/' . $job->image);
            }

            try {

                R::trash($job);
                header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
            }
        }
    }
    
    public function deleteselected() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        $app = 0;
        foreach ($deleteidsArray as $id) {
            $applicants = R::findAll('applicant','jobid = '.$id);
            if(count($applicants) > 0)
            {
                $app = -1;
            }
            else
            {
                $job = R::load('job', $id);
                if (file_exists('../../upload/' . $this->controllname . '/' . $job->image)) {
                    //echo $imageNewName;
                    chmod('../../upload/' . $this->controllname . '/' . $job->image, 0777);
                    unlink('../../upload/' . $this->controllname . '/' . $job->image);
                }
                R::trash($job);
            }
        }
        if($app == -1)
            echo $app;
        else
            echo 1;
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
