<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'features';
        $this->shcontrollname = 'القائمة البريدية';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'features';
        $active[1] = 'features'; //controller name or tab name
        $this->active = $active;

        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);

        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        #select table
        $setting = R::getAll('SELECT * FROM features where id = 1 order by id desc');
        if (count($setting) > 0) {

            //send info to html
            $this->smarty->assign('features', $setting[0]);
//            print_r($setting[0]);
        }
//
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('features/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    //the add and update in features table
    public function edit() {

        //check login
        autho::checkautho($this->hosturl);

        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get all vars
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content = filter_input(INPUT_POST, 'content');
        $content_en = filter_input(INPUT_POST, 'content_en');

        $title2 = filter_input(INPUT_POST, 'title2');
        $title_en2 = filter_input(INPUT_POST, 'title_en2');
        $content2 = filter_input(INPUT_POST, 'content2');
        $content_en2 = filter_input(INPUT_POST, 'content_en2');

        $title3 = filter_input(INPUT_POST, 'title3');
        $title_en3 = filter_input(INPUT_POST, 'title_en3');
        $content3 = filter_input(INPUT_POST, 'content3');
        $content_en3 = filter_input(INPUT_POST, 'content_en3');

        #select table
        $setting = R::findAll('features', 'order by id desc');
        if (count($setting) > 0) {
            //update current
            //get id vars in update statution
            $id = filter_input(INPUT_POST, 'id');

            // echo $id ;

            $setting = R::load('features', $id);
//            print_r($setting);
//
//            //fill object with data
            $setting->title = $title;
            $setting->title_en = $title_en;
            $setting->content = $content;
            $setting->content_en = $content_en;

            $setting->title2 = $title2;
            $setting->title_en2 = $title_en2;
            $setting->content2 = $content2;
            $setting->content_en2 = $content_en2;

            $setting->title3 = $title3;
            $setting->title_en3 = $title_en3;
            $setting->content3 = $content3;
            $setting->content_en3 = $content_en3;

            R::store($setting);

            try {
                R::store($setting);
                header('Location:' . $this->hosturl . '/' . $this->controllname . '/index');
            } catch (Exception $e) {
//                header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
            }
        } else {
            //insert new
            $setting = R::dispense('features');

            //fill object with data
            $setting->title = $title;
            $setting->title_en = $title_en;
            $setting->content = $content;
            $setting->content_en = $content_en;

            $setting->title2 = $title2;
            $setting->title_en2 = $title_en2;
            $setting->content2 = $content_en2;
            $setting->content_en2 = $content_en2;

            $setting->title3 = $title3;
            $setting->title_en3 = $title_en3;
            $setting->content3 = $content3;
            $setting->content_en3 = $content_en3;
            try {
                $id = R::store($setting);
                header('Location:' . $this->hosturl . '/' . $this->controllname);
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
            }
        }
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
