<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check authoize
        //autho::checkauthoize($autho,$this->hosturl);
        //check login
        autho::checkautho($this->hosturl);

        //recieve error type
        $errortype = filter_input(INPUT_GET, 'ac');
        $controllname = filter_input(INPUT_GET, 'id');
        $this->smarty->assign('controllname', $controllname);
        switch ($errortype) {
            case 'notadd':
                $this->smarty->assign('errormsg', 'حدثت مشكله فى الاضافه!!');
                break;
            case 'notupdate':
                $this->smarty->assign('errormsg', 'حدثت مشكله فى التعديل!!');
                break;
            case 'relate':
                $this->smarty->assign('errormsg', 'هذا العنصر مرتبط بعناصر اخرى!!');
                break;
            case 'notdel':
                $this->smarty->assign('errormsg', 'حدثت مشكله فى عمليه الحذف!!');
                break;
            case 'insetting':
                $this->smarty->assign('errormsg', 'لم يتم تحديث التصريحات ..!!');
                break;
            case 'autho':
                $this->smarty->assign('controllname', '');
                $this->smarty->assign('errormsg', 'ليس مسموح لك بالدخول الى هذه الصفحه . راجع المدير؟');
                break;
            case 'dup':
                $this->smarty->assign('errormsg', 'لا يمكن اضافه هذا العنصر لوجوده');
                break;
            case 'related':
                $this->smarty->assign('errormsg', 'هذا العنصر مرتبط بعناصر اخرى');
                break;
            case 'errormsg':
                $this->smarty->assign('errormsg', $_SESSION["error_msg"]);
                unset($_SESSION["error_msg"]);
                break;
            default:
                $this->smarty->assign('controllname', 'index');
                $this->smarty->assign('errormsg', 'حدثت مشكله ما...');
                break;
        }

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('_main/_error.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
