<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'courses';
        $this->shcontrollname = 'الدورات التدريبية';
        $this->tableName = 'courses';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'courses'; //controller name or tab name
        $active[1] = 'courses'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $allSpeciality = R::findAll('speciality');
        $this->smarty->assign('allSpeciality', $allSpeciality);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('subject/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $sepcialityid = filter_input(INPUT_POST, 'sepcialityid');
        $price = filter_input(INPUT_POST, 'price');
        $city = filter_input(INPUT_POST, 'city');
        $city_en = filter_input(INPUT_POST, 'city_en');
        $duration = filter_input(INPUT_POST, 'duration');
        $details = filter_input(INPUT_POST, 'details');
        $details_en = filter_input(INPUT_POST, 'details_en');
        $image = uploadnew('course', False, 0, 0, 'courses');

        //here the add
        $courses = R::dispense('courses');
        $courses->title = $title;
        $courses->title_en = $title_en;
        $courses->sepcialityid = $sepcialityid;
        $courses->price = $price;
        $courses->city = $city;
        $courses->city_en = $city_en;
        $courses->duration = $duration;
        $courses->details = $details;
        $courses->details_en = $details_en;
        $courses->image = $image;

        try {
            $id = R::store($courses);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $this->smarty->assign('delMsg', $_SESSION['delMsg']);
        unset($_SESSION['delMsg']);

        $allSubject = R::findAll('courses', ' order by id desc');
        foreach ($allSubject as $sub) {
            $sub->speciality = R::load('speciality', $sub->sepcialityid)->title;
        }
        $this->smarty->assign('returnedData', $allSubject);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('subject/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all here
        $course = R::load('courses', $itemid);
        $this->smarty->assign('course', $course);

        $allSpeciality = R::findAll('speciality');
        $this->smarty->assign('allSpeciality', $allSpeciality);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('subject/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $sepcialityid = filter_input(INPUT_POST, 'sepcialityid');
        $price = filter_input(INPUT_POST, 'price');
        $city = filter_input(INPUT_POST, 'city');
        $city_en = filter_input(INPUT_POST, 'city_en');
        $duration = filter_input(INPUT_POST, 'duration');
        $details = filter_input(INPUT_POST, 'details');
        $details_en = filter_input(INPUT_POST, 'details_en');
        $image = uploadupdate('course', 'imageurl', False, 0, 0, 'courses');
        $id = filter_input(INPUT_POST, 'id');

        //load all parents here
        $courses = R::load('courses', $id);

        //here the upadte
        $courses->title = $title;
        $courses->title_en = $title_en;
        $courses->sepcialityid = $sepcialityid;
        $courses->price = $price;
        $courses->city = $city;
        $courses->city_en = $city_en;
        $courses->duration = $duration;
        $courses->details = $details;
        $courses->details_en = $details_en;
        $courses->image = $image;

        try {
            R::store($courses);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $subject = R::load('courses', $itemid);

        try {
            R::trash($subject);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function deleteselected() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        $cat = 0;
        foreach ($deleteidsArray as $id) {
            $category = R::findAll('category', 'subject_id = ' . $id);
            if (count($category) > 0) {
                $cat = -1;
            } else {
                $subject = R::load('subject', $id);
                R::trash($subject);
            }
        }
        if ($cat == -1)
            echo $cat;
        else
            echo 1;
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
