<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'country';
        $this->shcontrollname = 'الدول';
        $this->tableName = 'country';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'country'; //controller name or tab name
        $active[1] = 'country'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('country/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');

        //here the add
        $country = R::dispense('country');
        $country->title = $title;
        $country->title_en = $title_en;
        $country->del = 0;


        try {
            $id = R::store($country);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $country = R::getAll('SELECT * FROM `country` WHERE `del` = 0');
        $this->smarty->assign('returnedData', $country);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('country/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $country = R::load('country', $itemid);
        $this->smarty->assign('returnedData', $country);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('country/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $country = R::load('country', $id);

        //here the upadte
        $country->title = $title;
        $country->title_en = $title_en;
        $country->del = 0;


        try {
            R::store($country);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id'); //filter_input(INPUT_POST, 'itemid');
        $related = R::findAll('governorate', 'country_id = ' . $itemid);

        if (empty($related)) {
            //load all item here
            $country = R::load('country', $itemid);
            $country->del = 1;
            try {
                R::store($country);
                header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
            }
        } else {
            //echo 1;
            header('Location:' . $this->hosturl . '/error/related/' . $this->controllname);
        }
    }

    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
            $country = R::load('country', $id);
            $country->del = 1;
            R::store($country);
        }
        echo 1;
    }

    //ajax
    public function governorate() {

        $country = (int) filter_input(INPUT_POST, "country");
        $json = [];
        if ($country > 0) {
            $sQuery = "select * from governorate ";
            if (isset($_POST['q']) && !empty($_POST['q'])) {
                $search = $_POST['q'];
                $sQuery .= " where (title LIKE '%" . $search . "%') ";
            } else {
                $sQuery .= " where 1 ";
            }
            $sQuery .= " and del=0 and country_id = $country order by id asc limit 5";
            $result_group = R::getAll($sQuery);
            foreach ($result_group as $row) {
                $json[] = ['id' => $row["id"], 'text' => $row["title"]];
            }
        } else {
            $json[] = ['id' => "", 'text' => "اختر الدولة اولا"];
        }
        echo json_encode($json);
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
