<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'clients';
        $this->shcontrollname = 'العملاء';
        $this->tableName = 'clients';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'clients'; //controller name or tab name
        $active[1] = 'clients'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('clients/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $link = filter_input(INPUT_POST, 'link');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content = filter_input(INPUT_POST, 'content');
        $content_en = filter_input(INPUT_POST, 'content_en');
        $image = uploadnew('client', False, 0, 0, 'clients');

        //here the add
        $clients = R::dispense('clients');
        $clients->title = $title;
        $clients->title_en = $title_en;
        $clients->content = $content;
        $clients->content_en = $content_en;
        $clients->image = $image;
        $clients->link = $link;
        $clients->del = 0;


        try {
            $id = R::store($clients);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $clients = R::getAll('SELECT * FROM `clients` WHERE `del` = 0');
        $this->smarty->assign('returnedData', $clients);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('clients/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $$clients = R::findAll('clients', 'order by id desc');
        $this->smarty->assign('clients', $clients);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $clients = R::load('clients', $itemid);
        $this->smarty->assign('returnedData', $clients);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('clients/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $code = filter_input(INPUT_POST, 'code');
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content = filter_input(INPUT_POST, 'content');
        $content_en = filter_input(INPUT_POST, 'content_en');
        $image = uploadupdate('client', 'imageurl', False, 0, 0, 'clients');
        $link = filter_input(INPUT_POST, 'link');


        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $clients = R::load('clients', $id);

        //here the upadte
        $clients->code = $code;
        $clients->title = $title;
        $clients->title_en = $title_en;
        $clients->content = $content;
        $clients->content_en = $content_en;
        $clients->image = $image;
        $clients->link = $link;
        $clients->del = 0;


        try {
            R::store($clients);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $clients = R::load('clients', $itemid);

        $clients->del = 1;


        try {
            R::store($clients);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
            $clients = R::load('clients', $id);

            $clients->del = 1;
            R::store($clients);
        }
        echo 1;
    }

    public function hide() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        //autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_POST, 'itemid');
        $ishide = filter_input(INPUT_POST, 'ishide');
        //load all item here
        $slider = R::load('clients', $itemid);
        $slider->hide = $ishide;
        try {
            R::store($slider);
            //change the button
            echo '1';
        } catch (Exception $e) {
            echo '0';
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
