<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'city';
        $this->shcontrollname = 'المدن';
        $this->tableName = 'city';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'city'; //controller name or tab name
        $active[1] = 'city'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $this->smarty->assign('delMsg', $_SESSION['delMsg']);

        $allcountry = R::getAll('SELECT * FROM `country` WHERE `del` = 0');
        $this->smarty->assign('allcountry', $allcountry);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('city/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $governorate = filter_input(INPUT_POST, 'governorate');
        $itr = (int) filter_input(INPUT_POST, 'itr');

        //here the add
        $city = R::dispense('city');
        $city->title = $title;
        $city->title_en = $title_en;
        $city->governorate_id = $governorate;
        $city->hide = 1;
        $city->del = 0;
        R::begin();
        try {
            $id = R::store($city);
            for ($i = 1; $i <= $itr; $i++) {
                $region = filter_input(INPUT_POST, 'region' . $i);
                $region_en = filter_input(INPUT_POST, 'region_en' . $i);

                if (!$region) {
                    continue;
                }

                //here the add
                $cityregion = R::dispense('cityregion');
                $cityregion->city_id = $id;
                $cityregion->title = $region;
                $cityregion->title_en = $region_en;
                R::store($cityregion);
            }

            R::commit();
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            R::rollback();
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $this->smarty->assign('delMsg', $_SESSION['delMsg']);
        unset($_SESSION['delMsg']);

        $allCity = R::getAll("select city.*,governorate.title as govTitle from city  join governorate on governorate.id = city.governorate_id where city.del=0");
        $this->smarty->assign('returnedData', $allCity);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('city/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        $allcountry = R::getAll('SELECT * FROM `country` WHERE `del` = 0');
        $this->smarty->assign('allcountry', $allcountry);


        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all here
        $city = R::load('city', $itemid);
        $this->smarty->assign('city', $city);

        $cityregions = R::findAll('cityregion', ' city_id = ? ', [ $itemid]);
        $this->smarty->assign('cityregions', $cityregions);

        $city_governorate = R::load("governorate", $city->governorate_id);
        $this->smarty->assign('city_governorate', $city_governorate);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('city/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $governorate = filter_input(INPUT_POST, 'governorate');
        $itr = (int) filter_input(INPUT_POST, 'itr');
        $id = filter_input(INPUT_POST, 'id');

        //load all parents here
        //here the add
        $city = R::load('city', $id);
        $city->title = $title;
        $city->title_en = $title_en;
        $city->governorate_id = $governorate;

        R::begin();
        try {
            R::store($city);
            for ($i = 1; $i <= $itr; $i++) {
                $region = filter_input(INPUT_POST, 'region' . $i);
                $region_en = filter_input(INPUT_POST, 'region_en' . $i);
                $regid = filter_input(INPUT_POST, 'regid' . $i);
                var_dump($region . "**" . $regid);
                if (!$region) {
                    continue;
                }


                if (!$regid) {
                    //here the add
                    $cityregion = R::dispense('cityregion');
                    $cityregion->city_id = $id;
                    $cityregion->title = $region;
                    $cityregion->title_en = $region_en;
                    R::store($cityregion);
                } else {
                    //here update
                    $cityregion = R::load('cityregion', $regid);
                    $cityregion->city_id = $id;
                    $cityregion->title = $region;
                    $cityregion->title_en = $region_en;
                    R::store($cityregion);
                }
            }
            R::commit();
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            R::rollback();
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        //$branch = R::findAll('branch', 'cityid = ' . $itemid);

        try {
            if (count($branch) > 0) {
                //$_SESSION['delMsg'] = 'لم يتم حذف المدينة لأن بها فروع';
            } else {
                $city = R::load('city', $itemid);
                $city->del = 1;
                R::store($city);
            }
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function deleteselected() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        $cat = 0;
        foreach ($deleteidsArray as $id) {
            //$branch = R::findAll('branch', 'cityid = ' . $id);
            if (count($branch) > 0) {
                //$cat = -1;
            } else {
                $city = R::load('city', $id);
                $city->del = 1;
                R::store($city);
            }
        }
        if ($cat == -1)
            echo $cat;
        else
            echo 1;
    }

    public function delregion() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_POST, 'id');

        $obj = R::load('cityregion', $itemid);
        $done = 0;
        try {
            R::trash($obj);
            $done = 1;
            echo $done;
        } catch (Exception $e) {
            $done = 0;
            echo $done;
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
