<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'category';
        $this->shcontrollname = 'المركز الاعلامى';
        $this->tableName = 'category';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'category'; //controller name or tab name
        $active[1] = 'category'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $this->smarty->assign('msg', $_SESSION['cmsg']);
        unset($_SESSION['cmsg']);

        $category = R::findAll('category', ' ORDER BY id DESC');
        $this->smarty->assign('category', $category);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('category/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function check() {
        //check login
        autho::checkautho($this->hosturl);

        $name = filter_input(INPUT_POST, 'datainput3');

        $checkedit = filter_input(INPUT_POST, 'edit3');


        if (!$checkedit) {
            //new
            $checkname = R::getRow('SELECT * FROM category WHERE name = ?  LIMIT 1', [$name]);
            if (count($checkname) > 0) {
                echo "yes";
            } else {
                echo "no";
            }
        } else {
            //edit
            $checkname = R::getRow('SELECT * FROM category WHERE name = ?  LIMIT 1', [$name]);
            if (count($checkname) > 0) {
                if ($checkedit == $checkname['name']) {
                    echo "no";
                } else {
                    echo "yes";
                }
            } else {
                echo "no";
            }
        }
    }

    public function add() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('category/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $category = R::dispense('category');
        $category->name = $name;
        $category->name_en = $name_en;


        try {
            //generate random password for electa





            $id = R::store($category);

            header('Location:' . $this->hosturl . '/' . $this->controllname);
        } catch (Exception $e) {

            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $category = R::findAll('category', ' ORDER BY id DESC');
        $this->smarty->assign('category', $category);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('category/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $id = filter_input(INPUT_GET, 'id');
        // R::fancyDebug(true);
        $category = R::load('category', $id);
        $this->smarty->assign('category', $category);


        // print_r($container_arr);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('category/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $name = filter_input(INPUT_POST, 'name');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $id = filter_input(INPUT_POST, 'id');

        $category = R::load('category', $id);
        $category->name = $name;
        $category->name_en = $name_en;
//
//        echo $name;
        try {

            R::store($category);

            header('Location:' . $this->hosturl . '/' . $this->controllname);
        } catch (Exception $e) {

            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $choosedItemArr = $_POST['choosedItem'];

        //get id for item
        $id = filter_input(INPUT_GET, 'id');

        if (count($choosedItemArr) > 0) {          //delete multiple
            foreach ($choosedItemArr as $id) {
                try {
                    $gallery = R::findAll('gallery', 'cat_id = ' . $id . ' ');
//                    $videoes = R::findAll('videocategories','category_id = '.$id);
//                    if(count($gallery) > 0 || count($videoes) > 0)
//                    {
//                        $_SESSION['cmsg'] = "بعض العناصر لم يتم حذفها لان بها صور أو فيديوهات";
//                    }
//                    else
//                    {
//                        R::trash('category', $id);
//                        //trash gallery related to category
//                        foreach ($gallery as $value) {
//                            $galleryid = $value->id;
//                            R::trash('gallery', $galleryid);
//                        }
//                    }

                    R::trash('category', $id);
                    //trash gallery related to category
                    foreach ($gallery as $value) {
                        $galleryid = $value->id;
                        R::trash('gallery', $galleryid);
                    }
                    header('Location:' . $this->hosturl . '/' . $this->controllname);
                } catch (Exception $e) {

                    header('Location:' . $this->hosturl . '/error/notdel');
                }
            }
        } else if (!empty($id)) { //delete one item
            try {
                $gallery = R::findAll('gallery', 'cat_id = ' . $id . ' ');
                //$videoes = R::findAll('videocategories','category_id = '.$id);
                //if(count($gallery) > 0 || count($videoes) > 0)
//                if(count($gallery) > 0)
//                {
//                    $_SESSION['cmsg'] = "لا يمكنك حذف هذا الألبوم لأن به صور";
//                }
//                else {
//                    R::trash('category', $id);
//                    foreach ($gallery as $value) {
//                        $galleryid = $value->id;
//                        R::trash('gallery', $galleryid);
//                    }
//                }

                R::trash('category', $id);
                foreach ($gallery as $value) {
                    $galleryid = $value->id;
                    R::trash('gallery', $galleryid);
                }
                header('Location:' . $this->hosturl . '/' . $this->controllname);
            } catch (Exception $e) {

                header('Location:' . $this->hosturl . '/error/notdel');
            }
        } else {
            header('Location:' . $this->hosturl . '/error/notdel');
        }
    }

    public function deleteselected() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        $app = 0;
        foreach ($deleteidsArray as $id) {

            $gallery = R::findAll('gallery', 'cat_id = ' . $id . ' ');
//            $videoes = R::findAll('videocategories','category_id = '.$id);
//            if(count($gallery) > 0 || count($videoes) > 0)
//            {
//                $app = -1;
//            }
//            else
//            {
//                R::trash('category', $id);
//            }
            R::trash('category', $id);
            foreach ($gallery as $value) {
                $galleryid = $value->id;
                R::trash('gallery', $galleryid);
            }
        }
        if ($app == -1)
            echo $app;
        else
            echo 1;
    }

    public function gallery() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);



        //get id for item
        $id = filter_input(INPUT_GET, 'id');
//        R::debug(true);
        $gallery = R::getAll('select *,1 as fileType from gallery where cat_id=' . $id . '');
        $gallery_arr = array();
        $videoExtentionArr = array("flv", "mpeg", "mpg", "mpe", "avi", "wmv", "mov", "mp4", "m4v");
        foreach ($gallery as $value) {
            $fileExt = explode(".", strtolower($value["name"]))[1];
            if (in_array($fileExt, $videoExtentionArr)) {
                //video
                $value["fileType"] = "video";
            } else {
                //image
                $value["fileType"] = "image";
            }
            array_push($gallery_arr, $value);
        }
        $this->smarty->assign('gallery', $gallery_arr);
        $this->smarty->assign('cat_id', $id);
//        print_r($gallery);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('category/gallery.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
