<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'branch';
        $this->shcontrollname = 'الفروع';
        $this->tableName = 'branch';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'branch'; //controller name or tab name
        $active[1] = 'branch'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $allCity = R::findAll('city');
        $this->smarty->assign('allCity', $allCity);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('branch/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $address = filter_input(INPUT_POST, 'address');
        $address_en = filter_input(INPUT_POST, 'address_en');
        $regionid = filter_input(INPUT_POST, 'regionid');
        $cityid = filter_input(INPUT_POST, 'cityid');
        $phone = filter_input(INPUT_POST, 'phone');
        $lat = filter_input(INPUT_POST, 'lat');
        $long = filter_input(INPUT_POST, 'long');

        //here the add
        $branch = R::dispense('branch');
        $branch->title = $title;
        $branch->title_en = $title_en;
        $branch->address = $address;
        $branch->address_en = $address_en;
        $branch->regionid = $regionid;
        $branch->cityid = $cityid;
        $branch->phone = $phone;
        $branch->lat = $lat;
        $branch->long = $long;
        try {
            $id = R::store($branch);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $branchs = R::findAll('branch');
        $this->smarty->assign('returnedData', $branchs);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('branch/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $branch = R::load('branch', $itemid);
        $this->smarty->assign('returnedData', $branch);

        $allCity = R::findAll('city', 'regionid = ' . $branch->regionid);
        $this->smarty->assign('allCity', $allCity);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('branch/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $address = filter_input(INPUT_POST, 'address');
        $address_en = filter_input(INPUT_POST, 'address_en');
        $regionid = filter_input(INPUT_POST, 'regionid');
        $cityid = filter_input(INPUT_POST, 'cityid');
        $phone = filter_input(INPUT_POST, 'phone');
        $lat = filter_input(INPUT_POST, 'lat');
        $long = filter_input(INPUT_POST, 'long');

        $id = filter_input(INPUT_POST, 'id');


        //R::debug( TRUE );
        //load all parents here
        $branch = R::load('branch', $id);

        //here the upadte
        $branch->title = $title;
        $branch->title_en = $title_en;
        $branch->address = $address;
        $branch->address_en = $address_en;
        $branch->regionid = $regionid;
        $branch->cityid = $cityid;
        $branch->phone = $phone;
        $branch->lat = $lat;
        $branch->long = $long;

        try {
            R::store($branch);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function approveItem() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_POST, 'itemid');
        $ishide = filter_input(INPUT_POST, 'ishide');
        //load all item here
        $branch = R::load('branch', $itemid);
        $branch->hide = $ishide;
        try {
            R::store($branch);
            //change the button
            echo '1';
        } catch (Exception $e) {
            echo '0';
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $branch = R::load('branch', $itemid);
        if (file_exists('../../upload/' . $this->controllname . '/' . $branch->image)) {
            //echo $imageNewName;
            chmod('../../upload/' . $this->controllname . '/' . $branch->image, 0777);
            unlink('../../upload/' . $this->controllname . '/' . $branch->image);
        }

        try {

            R::trash($branch);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function getCity() {
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item

        $id = filter_input(INPUT_POST, 'id');

        $allCity = R::findAll('city', 'regionid = ' . $id);
        $data = '<option value="">اختر المدينة</option>';
        foreach ($allCity as $city) {
            $data .= '<option value="' . $city->id . '">' . $city->title . '</option>';
        }

        print_r($data);
    }

    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
            $branch = R::load('branch', $id);
            R::trash($branch);
        }
        echo 1;
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
