<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $tableName;
    public $active;
    private $cards_arr;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'articls';
        $this->shcontrollname = 'مقالات';
        $this->tableName = 'articls';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'articls'; //controller name or tab name
        $active[1] = 'articls'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
//        $articlecate = R::getAll("select * from articlecate where del =0 order by id desc");
//
//        $this->smarty->assign('articlecate', $articlecate);
        $this->smarty->display('articls/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //vars here
        $title = filter_input(INPUT_POST, 'title');
        $content = filter_input(INPUT_POST, 'content');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content_en = filter_input(INPUT_POST, 'content_en');
        //$article_category = filter_input(INPUT_POST, 'article_category');
        $name_ar = filter_input(INPUT_POST, 'name_ar');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $date = filter_input(INPUT_POST, 'date');
        $main_show = filter_input(INPUT_POST, 'main_show');

        $image = uploadnew('articls', False, 0, 0, 'articls');

        //here the add
        $articls = R::dispense('articls');
        $articls->title = $title;
        $articls->content = $content;
        $articls->title_en = $title_en;
        $articls->content_en = $content_en;
        $articls->image = $image;

        $articls->writer = $name_ar;
        $articls->writer_en = $name_en;
        $articls->date = $date;
        //$articls->article_cat_id = $article_category;
        $articls->main_show = $main_show;
        $articls->del = 0;
        $articls->type = 0;
        $articls->user_id =$_SESSION['user_id'];



        try {
            R::store($articls);

            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $articls = R::findAll("articls","del = 0");
//        foreach($articls as $article)
//        {
//            $comments = R::findAll('articlecomments','approved = 0 and article_id = '.$article->id);
//            $article->unread = count($comments);
//        }
        $this->smarty->assign('returnedData', $articls);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('articls/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }
    
    public function showComments() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        
        $id = filter_input(INPUT_GET, 'id');
        $articleData = R::load('articls', $id);
        $this->smarty->assign('articleData', $articleData);
        
        $allComments = R::findAll('articlecomments','article_id = '.$id);
        foreach ($allComments as $comment)
        {
            $userInfo = R::load('registerinfo', $comment->user_id);
            $comment->username = $userInfo->name;
            $comment->image = $userInfo->image_1;
        }
        $this->smarty->assign('allComments',$allComments);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('articls/comments.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
//        $article_cate = R::findAll('articlecate', ' where del =0 order by id desc');
//        $this->smarty->assign('article_cate', $article_cate);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all here
        $articl = R::load('articls', $itemid);
        $this->smarty->assign('returnedData', $articl);






        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('articls/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {


        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $title = filter_input(INPUT_POST, 'title');
        $content = filter_input(INPUT_POST, 'content');
        $title_en = filter_input(INPUT_POST, 'title_en');
        $content_en = filter_input(INPUT_POST, 'content_en');
        //$article_category = filter_input(INPUT_POST, 'article_category');
        $name_ar = filter_input(INPUT_POST, 'name_ar');
        $name_en = filter_input(INPUT_POST, 'name_en');
        $date = filter_input(INPUT_POST, 'date');
        $main_show = filter_input(INPUT_POST, 'main_show');

        $image = uploadupdate('articls', 'imageurl', False, 0, 0, 'articls');

        $id = filter_input(INPUT_POST, 'id');




        //here the add
        $articls = R::load('articls', $id);
        $articls->title = $title;
        $articls->content = $content;
        $articls->title_en = $title_en;
        $articls->content_en = $content_en;
        $articls->image = $image;

        $articls->writer = $name_ar;
        $articls->writer_en = $name_en;
        $articls->date = $date;
        //$articls->article_cat_id = $article_category;
        $articls->main_show = $main_show;
        $id = R::store($articls);


        try {

            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $articls = R::load('articls', $itemid);
        $articls->del = 1;

        try {
            R::store($articls);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }
    
    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
            $articls = R::load('articls', $id);
            $articls->del = 1;
            R::store($articls);
        }
        echo 1;
    }
    
    public function delComment() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_POST, 'itemid');
        //load all item here
        
        try {
            R::trash('articlecomments',$itemid);
            echo 1;
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    public function approveItem() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_POST, 'itemid');
        $approved = filter_input(INPUT_POST, 'ishide');
        //load all item here
        $articls = R::load('articls', $itemid);
        if($approved == 0)
            $articls->main_show = 1;
        else
            $articls->main_show = 0;
        
        try {
            R::store($articls);
            echo 1;
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }
    
    public function approveComment() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        
        $id = filter_input(INPUT_GET, 'id');
        if(empty($id))
        {
            $itemid = filter_input(INPUT_POST, 'itemid');
            $approved = filter_input(INPUT_POST, 'ishide');
            //load all item here
            $articls = R::load('articlecomments', $itemid);
            if($approved == 0)
                $articls->approved = 1;
            else
                $articls->approved = 0;

            try {
                R::store($articls);
                echo 1;
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
            }
        }
        else {
            try {
                R::exec('update articlecomments set approved = 1 where article_id = '.$id);
                header('Location:' . $this->hosturl . '/' . $this->controllname.'/showComments/'.$id);
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
            }
        }
    }
    
    //approve checked Comments
    public function ApproveChecked() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $approveidsString = $_POST['approveids'];
        $approveidsArray = explode(',', $approveidsString);
        foreach ($approveidsArray as $id) {
            $comment = R::load('articlecomments', $id);
            $comment->approved = 1;
            R::store($comment);
        }
        echo 1;
    }
    
    public function refuseChecked() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $approveidsString = $_POST['approveids'];
        $approveidsArray = explode(',', $approveidsString);
        foreach ($approveidsArray as $id) {
            $comment = R::load('articlecomments', $id);
            $comment->approved = 0;
            R::store($comment);
        }
        echo 1;
    }
    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
