<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    //menu itr for input
    public $menuitr;

    // it will run in everytime with
    // default requried
    public function __construct() {
              require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->cards_arr = array();

        //here name of controll to known
        $this->controllname = 'article_cate';
        $this->shcontrollname = 'تصنيف المقالات';
        $this->tableName = 'articlecate';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'article_cate'; //controller name or tab name
        $active[1] = 'article_cate'; //controller name
        $this->active = $active;


        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $article_cate = R::findAll('articlecate' ,'where del = 0 and parent = 0');
        $this->smarty->assign('article_cate', $article_cate);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('article_cate/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);



        //vars here
        $name_ar = filter_input(INPUT_POST, 'name_ar');
        $name_en = filter_input(INPUT_POST, 'name_en');

        $parent = filter_input(INPUT_POST, 'parent');
        $image = uploadnew('article_cate', False, 0, 0, 'article_cate');


        //here the add
        $article = R::dispense('articlecate');
        $article->articlename_ar = $name_ar;
        $article->articlename_en = $name_en;
        $article->parent = $parent;
        $article->image = $image;
        $article->del = 0;



        try {
            R::store($article);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //here will load the menu show
        $article_cate= R::findAll('articlecate',' del=0 order by id desc');
        $this->smarty->assign('article_cate', $article_cate);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('article_cate/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        $article_cate = R::findAll('articlecate','where del = 0 and parent = 0');
        $this->smarty->assign('article_cate', $article_cate);
        //load all here
        $article_cates = R::load('articlecate', $itemid);
        $this->smarty->assign('article_cates', $article_cates);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('article_cate/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);



        $id = filter_input(INPUT_POST, 'id');


        //vars here
        $name_ar = filter_input(INPUT_POST, 'name_ar');
        $name_en = filter_input(INPUT_POST, 'name_en');

        $parent = filter_input(INPUT_POST, 'parent');
        $image = uploadupdate('article_cate', 'imageurl1', False, 0, 0, 'article_cate');
        //here the add
        $article_cate = R::load('articlecate', $id);
        $article_cate->articlename_ar = $name_ar;
        $article_cate->articlename_en = $name_en;
        $article_cate->parent = $parent;
        $article_cate->image = $image;
        $article_cate->del = 0;
        R::store($article_cate);

        header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all item here
        $article_cate = R::load('articlecate', $itemid);
        $article_cate->del = 1;


        try {
            R::store($article_cate);

            //change the button
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

 

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
