<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default contacturied
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'applicant';
        $this->shcontrollname = 'المتقدمين';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'jobs'; //controller name or tab name
        $active[1] = 'applicant'; //controller name
        $this->active = $active;

        #include upload function
        require_once("../../library/plugins/classupload/uploadfunctions.php");
        require "../../library/plugins/PHPMailer/PHPMailer.php";


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        #select table
        $allApplicants = R::findAll('applicant','del = 0');
        $allApplicants = R::findAll('applicant','del = 0');
        foreach ($allApplicants as $applicant)
        {
            $applicant->job = R::load('job', $applicant->jobid)->title;
            $applicant->nationality = R::load('country', $applicant->nationality)->title;
        }
        $this->smarty->assign('allApplicants', $allApplicants);
        $this->smarty->assign('today',date('Y-m-d'));

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('applicant/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }
    
    public function show() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        #select table
        $allApplicants = R::findAll('applicant','del = 0');
        foreach ($allApplicants as $applicant)
        {
            $applicant->job = R::load('job', $applicant->jobid)->title;
            $applicant->nationality = R::load('country', $applicant->nationality)->title;
        }
        $this->smarty->assign('allApplicants', $allApplicants);
        $this->smarty->assign('today',date('Y-m-d'));

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('applicant/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }
    public function edit()
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $id = filter_input(INPUT_GET, 'id');
        
        $applicant = R::load('applicant',$id);
        $allJob = R::findAll('job', 'hide = 0');
        $allCountry = R::findAll('country', 'del = 0');
        
        $this->smarty->assign('applicant', $applicant);
        $this->smarty->assign('allJob', $allJob);
        $this->smarty->assign('allCountry', $allCountry);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('applicant/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }
    
    public function updateit()
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $id = filter_input(INPUT_POST, 'appid');
        $jobId = filter_input(INPUT_POST, 'jobId');
        $name = filter_input(INPUT_POST, 'name');
        $email = filter_input(INPUT_POST, 'email');
        $address = filter_input(INPUT_POST, 'address');
        $nationality = filter_input(INPUT_POST, 'nationality');
        $phone = filter_input(INPUT_POST, 'phone');
        $eduQualify = filter_input(INPUT_POST, 'eduQualify');
        $specialize = filter_input(INPUT_POST, 'specialize');
        $gender = filter_input(INPUT_POST, 'gender');        
        $status = filter_input(INPUT_POST, 'status');
        $skill = filter_input(INPUT_POST, 'skill');        
        $certification = filter_input(INPUT_POST, 'certification');
        $oldFile = filter_input(INPUT_POST, 'oldFile');
        
        $email = trim($email);
        if($email)
            $file = uploadupdateout ('file', 'oldFile', FALSE, 0, 0, 'applicant',FALSE);
        else
            $file = uploadnewout('file', False, 0, 0, 'applicant',FALSE);

        $applicant = R::load('applicant',$id);
        
        $applicant->jobid = $jobId;
        $applicant->name = $name;
        $applicant->email = $email;
        $applicant->address = $address;
        $applicant->nationality = $nationality;
        $applicant->phone = $phone;
        $applicant->edu = $eduQualify;
        $applicant->specialize = $specialize;
        $applicant->gender = $gender;
        $applicant->status = $status;
        $applicant->skill = $skill;
        $applicant->certification = $certification;
        $applicant->status = $status;
        $applicant->file = $file;
        
        try {
            R::store($applicant);
            header('Location:' . $this->hosturl . '/' . $this->controllname);
        } catch (Exception $e) {

            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function details() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $id = filter_input(INPUT_GET, 'id');

        $applicant = R::load('applicant',$id);
        $applicant->job = R::load('job', $applicant->jobid)->title;
        $applicant->nationality = R::load('country', $applicant->nationality)->title;
        $this->smarty->assign('applicant', $applicant);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('applicant/detail.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');
        //load all item here
        $applicant = R::load('applicant', $itemid);
        $applicant->del =1;
        
        try {
            R::store($applicant);
            header('Location:' . $this->hosturl . '/' . $this->controllname);
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }
    
    public function deleteselected() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //get id for item
        $deleteidsString = $_POST['deleteids'];
        $deleteidsArray = explode(',', $deleteidsString);
        foreach ($deleteidsArray as $id) {
            $applicant = R::load('applicant', $id);
            $applicant->del = 1;
            R::store($applicant);
        }
        echo 1;
    }

    public function searchDate() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $from = filter_input(INPUT_POST, 'from');
        $to = filter_input(INPUT_POST, 'to');

        $allApplicants = R::findAll('applicant','del = 0 and adate >= "'.$from.'" and DATE(adate) <= "'.$to.'"');
        foreach ($allApplicants as $applicant)
        {
            $applicant->job = R::load('job', $applicant->jobid)->title;
            $applicant->nationality = R::load('country', $applicant->nationality)->title;
        }
        $this->smarty->assign('allApplicants',$allApplicants);
        $this->smarty->display('applicant/search.html');
    }
    
    public function checkMail() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'appid');
        $email = filter_input(INPUT_POST, 'email');
        
        $data = R::findOne('applicant','email = "'.$email.'" and id != '.$id);
        if(count($data)>0)
            echo 1;
    }
    
    //the add and update in contacts table
    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
