<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = '_myprofile';
        $this->shcontrollname = 'بياناتى';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        //autho::checkauthoize($this->controllname,$this->hosturl,$_SESSION['role_id']);
        //get id for item
        $itemid = $_SESSION['user_id'];

        //load all here
        $user = R::getRow('SELECT * FROM awusers WHERE user_id = ? LIMIT 1', [$itemid]);
        $this->smarty->assign('user', $user);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('_member/myprofile.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    //check useraname
    public function checkusername() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        //autho::checkauthoize($this->controllname,$this->hosturl,$_SESSION['role_id']);

        $username = filter_input(INPUT_POST, 'username');
        $checkedit = filter_input(INPUT_POST, 'editusername');


        if (!$checkedit) {
            //new
            $checkusername = R::getRow('SELECT * FROM awusers WHERE user_name = ? LIMIT 1', [$username]);
            if (count($checkusername) > 0) {
                echo "yes";
            } else {
                echo "no";
            }
        } else {

            //edit
            $checkusername = R::getRow('SELECT * FROM awusers WHERE user_name = ? LIMIT 1', [$username]);
            if (count($checkusername) > 0) {
                if ($checkedit == $checkusername['user_name']) {
                    echo "no";
                } else {
                    echo "yes";
                }
            } else {
                echo "no";
            }
        }
    }

    //check email
    public function checkemail() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        //autho::checkauthoize($this->controllname,$this->hosturl,$_SESSION['role_id']);

        $email = filter_input(INPUT_POST, 'email');
        $checkedit = filter_input(INPUT_POST, 'checkedit');

        if (!$checkedit) {
            //new
            $checkemail = R::getRow('SELECT * FROM awusers WHERE user_email = ? LIMIT 1', [$email]);

            if (count($checkemail) > 0) {
                echo "yes";
            } else {
                echo "no";
            }
        } else {

            //edit
            $checkemail = R::getRow('SELECT * FROM awusers WHERE user_email = ? LIMIT 1', [$email]);
            if (count($checkemail) > 0) {
                if ($checkedit == $checkemail['user_email']) {
                    echo "no";
                } else {
                    echo "yes";
                }
            } else {
                echo "no";
            }
        }
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'name');
        $email = filter_input(INPUT_POST, 'email');
        $role = $_SESSION['role_id'];
        $username = filter_input(INPUT_POST, 'username');
        $epassword = filter_input(INPUT_POST, 'epassword');
        $oldpassword = filter_input(INPUT_POST, 'oldpassword');
        $id = $_SESSION['user_id'];


        //new password or old password
        if (empty($epassword)) {
            $user_password_hash = $oldpassword;
        } else {
            $hash_cost_factor = (defined('HASH_COST_FACTOR') ? HASH_COST_FACTOR : null);
            $user_password_hash = password_hash($epassword, PASSWORD_DEFAULT, array('cost' => $hash_cost_factor));
        }


        $user_name = trim($username);
        $user_activation_hash = sha1(uniqid(mt_rand(), true));
        $user_email = trim($email);
        $user_registration_ip = $_SERVER['REMOTE_ADDR'];


        try {
            //here the add
            $edituser = R::exec('UPDATE awusers SET user_name = ?,user_password_hash = ?, user_email = ? ,role_id = ?,name = ? WHERE user_id = ?', [$user_name, $user_password_hash, $user_email, $role, $name, $id]);
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
