<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {
    
    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = '_controll';
        $this->shcontrollname = 'لوحه الكنترولات';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../library/plugins/Breadcrumbs/Breadcrumbs_ar.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'managment'; //controller name or tab name
        $active[1] = 'controll'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'controlladd';
                break;
            case 'show':$active[2] = 'controllshow';
                break;
            default :$active[2] = 'controllshow';
                break;
        }
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('_controll/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $label = filter_input(INPUT_POST, 'label');
        $name = filter_input(INPUT_POST, 'name');
        $propitr = filter_input(INPUT_POST, 'propitr');

        //here the add
        $controll = R::dispense('awcontroll');
        $controll->label = $label;
        $controll->name = $name;

        R::begin();
        try {
            $id = R::store($controll);
            for ($i = 1; $i <= $propitr; $i++) {
                $proplabel = filter_input(INPUT_POST, 'proplabel' . $i);
                $checkval = filter_input(INPUT_POST, 'checkval' . $i);

                if (!$proplabel) {
                    continue;
                }

                //here the add
                $controllprop = R::dispense('awcontrollprop');
                $controllprop->proplabel = $proplabel;
                $controllprop->checkval = $checkval;
                $controllprop->awcontroll = R::load('awcontroll', $id);
                R::store($controllprop);
            }
            R::commit();
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            R::rollback();
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        //load all parents here
        $awcontrolls = R::findAll('awcontroll');
        $this->smarty->assign('awcontrolls', $awcontrolls);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('_controll/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');

        //load all here
        $awcontroll = R::load('awcontroll', $itemid);
        $this->smarty->assign('awcontroll', $awcontroll);
        $this->smarty->assign('awcontrollprops', $awcontroll->ownAwcontrollprop);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('_controll/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function delprop() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_POST, 'propid');

        $rolecontrollprop = R::count('awrolecontrollprop', ' controllprop_id = ? ', [ $itemid]);
        if ($rolecontrollprop > 0) {
            //header('Location:'.$this->hosturl.'/error/relate/'.$this->controllname);
            exit();
        }

        $prop = R::load('awcontrollprop', $itemid);
        $done = 0;
        try {
            R::trash($prop);
            $done = 1;
            echo $done;
        } catch (Exception $e) {
            $done = 0;
            echo $done;
        }
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $label = filter_input(INPUT_POST, 'label');
        $name = filter_input(INPUT_POST, 'name');
        $propitr = filter_input(INPUT_POST, 'propitr');
        $id = filter_input(INPUT_POST, 'id');


        //here the update
        $controll = R::load('awcontroll', $id);
        $controll->label = $label;
        $controll->name = $name;

        R::begin();
        try {
            R::store($controll);
            for ($i = 1; $i <= $propitr; $i++) {
                $proplabel = filter_input(INPUT_POST, 'proplabel' . $i);
                $checkval = filter_input(INPUT_POST, 'checkval' . $i);
                $propid = filter_input(INPUT_POST, 'propid' . $i);

                if (!$proplabel) {
                    continue;
                }

                if (!$propid) {

                    //here the add
                    $controllprop = R::dispense('awcontrollprop');
                    $controllprop->proplabel = $proplabel;
                    $controllprop->checkval = $checkval;
                    $controllprop->awcontroll = R::load('awcontroll', $id);
                    R::store($controllprop);
                } else {

                    //here update
                    $controllprop = R::load('awcontrollprop', $propid);
                    $controllprop->proplabel = $proplabel;
                    $controllprop->checkval = $checkval;
                    $controllprop->awcontroll = R::load('awcontroll', $id);
                    R::store($controllprop);
                }
            }
            R::commit();
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            R::rollback();
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $itemid = filter_input(INPUT_GET, 'id');


        //load all item here
        $awcontroll = R::load('awcontroll', $itemid);

        //check in role menu
        $getallprop = R::findAll('awcontrollprop', 'awcontroll_id = ?', [$itemid]);
        foreach ($getallprop as $single) {
            $rolecontrollprop = R::count('awrolecontrollprop', ' controllprop_id = ? ', [ $single['id']]);
            if ($rolecontrollprop > 0) {
                header('Location:' . $this->hosturl . '/error/relate/' . $this->controllname);
                exit();
                //$awcontrollin = R::findAll('awrolecontrollprop', ' controllprop_id = ? ', [ $single['id']]);
                //R::trashAll($awcontrollin);
            }
        }


        R::begin();
        try {

            R::trash($awcontroll);
            $awcontroll->xownAwcontrollprop = array(); // to use xown must casacde it in db
            R::commit();
            header('Location:' . $this->hosturl . '/' . $this->controllname . '/show');
        } catch (Exception $e) {
            R::rollback();
            header('Location:' . $this->hosturl . '/error/notdel/' . $this->controllname);
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
